/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.gait;

import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.gait.Gait;
import com.equestricraft.core.horse.gait.Gallop;
import com.equestricraft.core.horse.gait.HorseGait;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.gait.Trot;

public class Canter
extends HorseGait {
    public static final Canter CANTER = new Canter();
    public static final Collected COLLECTED = CANTER.new Collected();
    public static final Working WORKING = CANTER.new Working();
    public static final Extended EXTENDED = CANTER.new Extended();

    private Canter() {
    }

    @Override
    public HorseGait getPrevious() {
        return Trot.TROT;
    }

    @Override
    public HorseGait getNext() {
        return Gallop.GALLOP;
    }

    @Override
    public String getAnimationName() {
        return "canter";
    }

    @Override
    public boolean hasVariant() {
        return true;
    }

    @Override
    public HorseSubGait getDefaultGait() {
        return WORKING;
    }

    @Override
    public HorseSubGait getLowestGait() {
        return COLLECTED;
    }

    @Override
    public HorseSubGait getHighestGait() {
        return EXTENDED;
    }

    @Override
    public double getCaloriesPerMinute() {
        return HorseSettings.getRideCaloriesMinuteCanter();
    }

    @Override
    public boolean hasLeadSelection() {
        return true;
    }

    public class Working
    extends HorseSubGait {
        private Working() {
            super(Gait.CANTER_WORKING);
        }

        @Override
        public HorseGait getMainGait() {
            return Canter.this;
        }
    }

    public class Collected
    extends HorseSubGait {
        private Collected() {
            super(Gait.CANTER_COLLECTED);
        }

        @Override
        public HorseGait getMainGait() {
            return Canter.this;
        }
    }

    public class Extended
    extends HorseSubGait {
        private Extended() {
            super(Gait.CANTER_EXTENDED);
        }

        @Override
        public HorseGait getMainGait() {
            return Canter.this;
        }
    }
}

