/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.gait;

import com.equestricraft.common.Dominance;
import com.equestricraft.core.allele.Allele;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.Gallop;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseGaitCache;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.gait.Walk;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class HorseGaitAccessor
extends AbstractHorseAccessor {
    private HorseSubGait currentGait = Halt.DEFAULT;
    private static final HorseGaitCache horseGaitCache = HorseGaitCache.getInstance();

    public HorseGaitAccessor(EQHorse horse) {
        super(horse);
    }

    public HorseSubGait getCurrentGait() {
        return this.currentGait;
    }

    public void setCurrentGait(HorseSubGait currentGait) {
        this.currentGait = currentGait;
    }

    public HorseSubGait getHighestAvailable() {
        return this.getHighestAvailable(Gallop.FULL);
    }

    public HorseSubGait getHighestAvailable(HorseSubGait maximum) {
        long stamina = this.horse.getStamina().getPoints();
        long warmUp = this.horse.getWarmUp().getValue();
        return this.streamUnlocked().filter(g -> g.getBlocksPerSecond() <= maximum.getBlocksPerSecond()).sorted(Comparator.comparing(HorseSubGait::getBlocksPerSecond).reversed()).filter(g -> g.getMinimumStamina() <= stamina).filter(g -> g.getRequiredWarmUpScore() <= warmUp).findFirst().orElse(Walk.COLLECTED);
    }

    public Stream<HorseSubGait> streamUnlocked() {
        List<HorseSubGait> subGaits = horseGaitCache.getAll();
        return subGaits.stream().filter(this::canHorseUseGait);
    }

    private boolean canHorseUseGait(HorseSubGait gait) {
        if (gait.getMainGait().isNatural()) {
            return true;
        }
        return this.horse.getGenetics().getAllele(Allele.DMRT3).dominance() == Dominance.DOMINANT;
    }
}

