/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.gait;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.gait.Gait;
import com.equestricraft.core.horse.gait.HorseGaitConfig;
import java.util.List;

public class HorseGaitConfigDatabase
implements RepositoryDatasource<HorseGaitConfig, Integer> {
    @Override
    public List<HorseGaitConfig> retrieveAll() {
        return Query.selectAllFrom("HORSE_GAIT").getList(this::getFromResultRow);
    }

    private HorseGaitConfig getFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        Gait identifier = row.getEnum("IDENTIFIER", Gait.class);
        String name = row.getString("NAME");
        float blocksPerSecond = row.getFloat("BLOCKS_PER_SECOND");
        long requiredWarmUpScore = row.getLong("REQUIRED_WARM_UP_SCORE");
        long targetWarmUpScore = row.getLong("TARGET_WARM_UP_SCORE");
        long minimumStamina = row.getLong("MINIMUM_STAMINA");
        long rearStamina = row.getLong("REAR_STAMINA");
        long staminaOffsetPerTick = row.getLong("STAMINA_OFFSET_PER_TICK");
        return new HorseGaitConfig(id, identifier, name, blocksPerSecond, requiredWarmUpScore, targetWarmUpScore, minimumStamina, rearStamina, staminaOffsetPerTick);
    }
}

