/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.gait;

import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.gait.Canter;
import com.equestricraft.core.horse.gait.Gait;
import com.equestricraft.core.horse.gait.HorseGait;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.gait.Walk;

public class Trot
extends HorseGait {
    public static final Trot TROT = new Trot();
    public static final Collected COLLECTED = TROT.new Collected();
    public static final Working WORKING = TROT.new Working();
    public static final Extended EXTENDED = TROT.new Extended();

    private Trot() {
    }

    @Override
    public HorseGait getPrevious() {
        return Walk.WALK;
    }

    @Override
    public HorseGait getNext() {
        return Canter.CANTER;
    }

    @Override
    public String getAnimationName() {
        return "trot";
    }

    @Override
    public boolean hasVariant() {
        return true;
    }

    @Override
    public HorseSubGait getDefaultGait() {
        return WORKING;
    }

    @Override
    public HorseSubGait getLowestGait() {
        return COLLECTED;
    }

    @Override
    public HorseSubGait getHighestGait() {
        return EXTENDED;
    }

    @Override
    public double getCaloriesPerMinute() {
        return HorseSettings.getRideCaloriesMinuteTrot();
    }

    public class Working
    extends HorseSubGait {
        private Working() {
            super(Gait.TROT_WORKING);
        }

        @Override
        public HorseGait getMainGait() {
            return Trot.this;
        }
    }

    public class Collected
    extends HorseSubGait {
        private Collected() {
            super(Gait.TROT_COLLECTED);
        }

        @Override
        public HorseGait getMainGait() {
            return Trot.this;
        }
    }

    public class Extended
    extends HorseSubGait {
        private Extended() {
            super(Gait.TROT_EXTENDED);
        }

        @Override
        public HorseGait getMainGait() {
            return Trot.this;
        }
    }
}

