/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.genetic;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.allele.Allele;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.genetic.HorseGeneticSession;
import com.equestricraft.core.horse.genetic.allele.HorseAlleleInfo;
import java.util.List;
import java.util.stream.Collectors;

public class HorseGeneticAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseGeneticSession horseGeneticSession;
    private List<HorseAlleleInfo> alleles = null;

    public HorseGeneticAccessor(EQHorse horse) {
        super(horse);
    }

    public List<HorseAlleleInfo> getAlleles() {
        if (this.alleles == null) {
            this.alleles = horseGeneticSession.retrieveStoredAlleleInformation(this.horse);
        }
        return this.alleles;
    }

    public HorseAlleleInfo getAllele(Allele allele) {
        return this.getAllele(allele.getId());
    }

    public HorseAlleleInfo getAllele(int alleleId) {
        return this.getAlleles().stream().filter(a -> a.allele().getId() == alleleId).findFirst().orElseThrow();
    }

    public String getDisplayString() {
        return this.getAlleles().stream().map(HorseAlleleInfo::display).collect(Collectors.joining(" "));
    }
}

