/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.genetic;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.Dominance;
import com.equestricraft.core.allele.Allele;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.horse.genetic.HorseGeneticSession;
import com.equestricraft.core.horse.genetic.PunnetSquareSession;
import com.equestricraft.core.horse.genetic.allele.AlleleDominanceMapping;
import com.equestricraft.core.horse.genetic.allele.HorseAllele;
import com.equestricraft.core.horse.genetic.allele.HorseAlleleInfo;
import com.equestricraft.core.horse.genetic.allele.HorseAlleleRepository;
import com.equestricraft.core.horse.genetic.allele.HorseAlleleReverseEngineerSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HorseGeneticSessionImpl
implements HorseGeneticSession {
    @Service
    private HorseAlleleRepository horseAlleleRepository;
    @Service
    private PunnetSquareSession punnetSquareSession;
    @Service
    private HorseAlleleReverseEngineerSession horseAlleleReverseEngineerSession;

    @Override
    public void initGeneticsFromParents(EQHorse horse) {
        EQHorse mother = horse.getMother().getEqHorse();
        EQHorse father = horse.getFather().getEqHorse();
        List<HorseAllele> alleles = Allele.stream().map(allele -> {
            Dominance motherDominance = mother.getGenetics().getAllele((Allele)((Object)allele)).dominance();
            Dominance fatherDominance = father.getGenetics().getAllele((Allele)((Object)allele)).dominance();
            Dominance foalDominance = this.punnetSquareSession.performPunnedSquare(motherDominance, fatherDominance);
            return new HorseAllele(horse.getId(), allele.getId(), foalDominance);
        }).toList();
        this.horseAlleleRepository.add(alleles);
    }

    @Override
    public void initGeneticsFromCoat(EQHorse horse, HorseCoatDetails coatDetails) {
        List<AlleleDominanceMapping> alleles = this.horseAlleleReverseEngineerSession.reverseEngineerAlleles(coatDetails);
        List<HorseAllele> horseAlleles = alleles.stream().map(a -> new HorseAllele(horse.getId(), a.allele().getId(), a.dominance())).toList();
        this.horseAlleleRepository.add(horseAlleles);
    }

    @Override
    public void setGeneticsForHorse(EQHorse horse, Map<Allele, Dominance> alleleDominanceMap) {
        ArrayList<HorseAllele> horseAlleles = new ArrayList<HorseAllele>(alleleDominanceMap.size());
        for (Map.Entry<Allele, Dominance> entry : alleleDominanceMap.entrySet()) {
            HorseAllele horseAllele = new HorseAllele(horse.getId(), entry.getKey().getId(), entry.getValue());
            horseAlleles.add(horseAllele);
        }
        this.horseAlleleRepository.add(horseAlleles);
    }

    @Override
    public List<HorseAlleleInfo> retrieveStoredAlleleInformation(EQHorse horse) {
        List<HorseAllele> horseAlleles = this.horseAlleleRepository.findMappingsByHorse(horse.getId());
        return Allele.stream().map(allele -> {
            Dominance dominance = horseAlleles.stream().filter(a -> a.getAlleleId() == allele.getId()).findFirst().map(HorseAllele::getDominance).orElse(Dominance.RECESSIVE);
            return this.buildAlleleInfo((Allele)((Object)allele), dominance);
        }).toList();
    }

    private HorseAlleleInfo buildAlleleInfo(Allele allele, Dominance dominance) {
        String dominanceDisplay = switch (dominance) {
            default -> throw new IncompatibleClassChangeError();
            case Dominance.DOMINANT -> allele.getDominantDisplay() + allele.getDominantDisplay();
            case Dominance.HETEROZYGOUS -> allele.getDominantDisplay() + allele.getRecessiveDisplay();
            case Dominance.RECESSIVE -> allele.getRecessiveDisplay() + allele.getRecessiveDisplay();
        };
        return new HorseAlleleInfo(allele, dominance, dominanceDisplay);
    }
}

