/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.genetic;

import com.equestricraft.common.Dominance;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.genetic.PunnetSquareSession;
import java.util.Arrays;

public class PunnetSquareSessionImpl
implements PunnetSquareSession {
    @Override
    public Dominance performPunnedSquare(Dominance dominance1, Dominance dominance2) {
        Dominance.IdentifierPair pair1 = dominance1.getPair();
        Dominance.IdentifierPair pair2 = dominance2.getPair();
        int squareIndex = NumberUtils.randomIntInRange(0, 3);
        Dominance.IdentifierPair pair = switch (squareIndex) {
            case 0 -> PunnetSquareSessionImpl.createPair(pair1.identifier1(), pair2.identifier1());
            case 1 -> PunnetSquareSessionImpl.createPair(pair1.identifier1(), pair2.identifier2());
            case 2 -> PunnetSquareSessionImpl.createPair(pair1.identifier2(), pair2.identifier1());
            case 3 -> PunnetSquareSessionImpl.createPair(pair1.identifier2(), pair2.identifier2());
            default -> throw new IllegalArgumentException(String.format("Invalid square index %s", squareIndex));
        };
        return this.getDominanceForPair(pair);
    }

    private Dominance getDominanceForPair(Dominance.IdentifierPair identifierPair) {
        return Arrays.stream(Dominance.values()).filter(d -> d.getPair().matches(identifierPair)).findFirst().orElseThrow();
    }

    public static Dominance.IdentifierPair createPair(Dominance.Identifier identifier1, Dominance.Identifier identifier2) {
        return new Dominance.IdentifierPair(identifier1, identifier2);
    }
}

