/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.genetic.allele;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.Dominance;
import com.equestricraft.core.horse.genetic.allele.HorseAllele;
import com.equestricraft.core.horse.genetic.allele.HorseAlleleKey;
import java.util.List;

public class HorseAlleleDatabase
implements RepositoryDatasource<HorseAllele, HorseAlleleKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_ALLELE_ID = "ALLELE_ID";
    private static final String COLUMN_DOMINANCE = "DOMINANCE";

    @Override
    public void create(HorseAllele horseAllele) {
        Query.insertInto("HORSE_ALLELE").columns(QueryColumn.column(COLUMN_HORSE_ID, horseAllele.getHorseId()), QueryColumn.column(COLUMN_ALLELE_ID, horseAllele.getAlleleId()), QueryColumn.column(COLUMN_DOMINANCE, horseAllele.getDominance())).execute();
    }

    @Override
    public List<HorseAllele> retrieveAll() {
        return Query.selectAllFrom("HORSE_ALLELE").getList(this::getFromResultRow);
    }

    private HorseAllele getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int alleleId = row.getInt(COLUMN_ALLELE_ID);
        Dominance dominance = row.getEnum(COLUMN_DOMINANCE, Dominance.class);
        return new HorseAllele(horseId, alleleId, dominance);
    }
}

