/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.genetic.allele;

import com.equestricraft.common.Dominance;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.allele.Allele;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.horse.genetic.allele.AlleleDominanceMapping;
import com.equestricraft.core.horse.genetic.allele.HorseAlleleReverseEngineerSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HorseAlleleReverseEngineerSessionImpl
implements HorseAlleleReverseEngineerSession {
    @Override
    public List<AlleleDominanceMapping> reverseEngineerAlleles(HorseCoatDetails horseCoatDetails) {
        List<AlleleDominanceMapping> colorAlleles = this.getAllelesForColor(horseCoatDetails.getColor());
        List<AlleleDominanceMapping> patternAlleles = this.getAllelesForMarkings(horseCoatDetails);
        return ListUtils.concat(colorAlleles, patternAlleles);
    }

    private List<AlleleDominanceMapping> getAllelesForColor(HorseCoatColor color) {
        return switch (color) {
            case HorseCoatColor.CHAMPAGNE -> ListUtils.concat(this.blackColorAlleles(), this.champagneAlleles());
            case HorseCoatColor.BLACK -> this.blackColorAlleles();
            case HorseCoatColor.SMOKEY_BLACK -> ListUtils.concat(this.blackColorAlleles(), this.heterozygousCream());
            case HorseCoatColor.SMOKEY_CREMELLO -> ListUtils.concat(this.blackColorAlleles(), this.dominantCream());
            case HorseCoatColor.PERLINO -> ListUtils.concat(this.bayColorAlleles(), this.dominantCream());
            case HorseCoatColor.BUCKSKIN -> ListUtils.concat(this.bayColorAlleles(), this.heterozygousCream());
            case HorseCoatColor.CHAMPAGNE_GOLD -> ListUtils.concat(this.bayColorAlleles(), this.champagneAlleles());
            case HorseCoatColor.STANDARD_BAY -> this.bayColorAlleles();
            case HorseCoatColor.CREMELLO -> ListUtils.concat(this.redColorAlleles(), this.dominantCream());
            case HorseCoatColor.PALOMINO -> ListUtils.concat(this.redColorAlleles(), this.heterozygousCream());
            case HorseCoatColor.PALOMINO_ROAN -> ListUtils.concat(this.redColorAlleles(), this.heterozygousCream(), this.roanAlleles());
            case HorseCoatColor.CHAMPAGNE_AMBER -> ListUtils.concat(this.redColorAlleles(), this.champagneAlleles());
            case HorseCoatColor.RED_ROAN -> ListUtils.concat(this.redColorAlleles(), this.roanAlleles());
            case HorseCoatColor.CHESTNUT -> this.redColorAlleles();
            case HorseCoatColor.BAY_ROAN -> ListUtils.concat(this.bayColorAlleles(), this.roanAlleles());
            default -> this.bayColorAlleles();
        };
    }

    private List<AlleleDominanceMapping> bayColorAlleles() {
        return List.of(new AlleleDominanceMapping(Allele.EXTENSION, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()), new AlleleDominanceMapping(Allele.AGOUTI, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
    }

    private List<AlleleDominanceMapping> redColorAlleles() {
        return List.of(new AlleleDominanceMapping(Allele.EXTENSION, Dominance.RECESSIVE), new AlleleDominanceMapping(Allele.AGOUTI, HorseAlleleReverseEngineerSessionImpl.getRandomDominance()));
    }

    private List<AlleleDominanceMapping> blackColorAlleles() {
        return List.of(new AlleleDominanceMapping(Allele.EXTENSION, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()), new AlleleDominanceMapping(Allele.AGOUTI, Dominance.RECESSIVE));
    }

    private List<AlleleDominanceMapping> champagneAlleles() {
        return List.of(new AlleleDominanceMapping(Allele.CHAMPAGNE, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
    }

    private List<AlleleDominanceMapping> dominantCream() {
        return List.of(new AlleleDominanceMapping(Allele.CREAM, Dominance.DOMINANT));
    }

    private List<AlleleDominanceMapping> heterozygousCream() {
        return List.of(new AlleleDominanceMapping(Allele.CREAM, Dominance.HETEROZYGOUS));
    }

    private List<AlleleDominanceMapping> roanAlleles() {
        return List.of(new AlleleDominanceMapping(Allele.ROAN, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
    }

    private List<AlleleDominanceMapping> getAllelesForMarkings(HorseCoatDetails coatDetails) {
        ArrayList<AlleleDominanceMapping> mappings = new ArrayList<AlleleDominanceMapping>();
        if (coatDetails.getGrayScale() > 0.0f) {
            mappings.add(new AlleleDominanceMapping(Allele.GRAY, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
        }
        for (HorseCoatMarking marking : coatDetails.getMarkings()) {
            switch (marking) {
                case APPALOOSA_1: 
                case APPALOOSA_3: {
                    mappings.add(new AlleleDominanceMapping(Allele.LEOPARD, Dominance.HETEROZYGOUS));
                    mappings.add(new AlleleDominanceMapping(Allele.PATN1, Dominance.RECESSIVE));
                    break;
                }
                case APPALOOSA_2: 
                case APPALOOSA_4: {
                    mappings.add(new AlleleDominanceMapping(Allele.LEOPARD, Dominance.HETEROZYGOUS));
                    mappings.add(new AlleleDominanceMapping(Allele.PATN1, Dominance.HETEROZYGOUS));
                    break;
                }
                case FEW_SPOT_APPALOOSA: {
                    mappings.add(new AlleleDominanceMapping(Allele.LEOPARD, Dominance.DOMINANT));
                    mappings.add(new AlleleDominanceMapping(Allele.PATN1, Dominance.DOMINANT));
                    break;
                }
                case LEOPARD_APPALOOSA_1: 
                case LEOPARD_APPALOOSA_2: {
                    mappings.add(new AlleleDominanceMapping(Allele.LEOPARD, Dominance.DOMINANT));
                    break;
                }
                case SNOWCAP_APPALOOSA_1: 
                case SNOWCAP_APPALOOSA_2: {
                    mappings.add(new AlleleDominanceMapping(Allele.LEOPARD, Dominance.DOMINANT));
                    mappings.add(new AlleleDominanceMapping(Allele.PATN1, HorseAlleleReverseEngineerSessionImpl.getRandomNonDominant()));
                    break;
                }
                case FRAME_OVERO: {
                    mappings.add(new AlleleDominanceMapping(Allele.OVERO, Dominance.DOMINANT));
                    break;
                }
                case OVERO_1: 
                case OVERO_2: {
                    mappings.add(new AlleleDominanceMapping(Allele.OVERO, Dominance.HETEROZYGOUS));
                    break;
                }
                case SABINO_1: 
                case SABINO_2: 
                case SABINO_3: {
                    mappings.add(new AlleleDominanceMapping(Allele.SABINO, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    break;
                }
                case SPLASH_1: 
                case SPLASH_2: 
                case SPLASH_3: 
                case SPLASH_4: {
                    mappings.add(new AlleleDominanceMapping(Allele.SPLASHED_WHITE, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    break;
                }
                case TOBIANO_1: 
                case TOBIANO_2: 
                case TOBIANO_3: 
                case TOBIANO_4: 
                case TOBIANO_5: 
                case TOBIANO_6: 
                case TOBIANO_7: 
                case TOBIANO_8: 
                case TOBIANO_9: 
                case TOBIANO_10: {
                    mappings.add(new AlleleDominanceMapping(Allele.TOBIANO, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    break;
                }
                case TOVERO_1: 
                case TOVERO_2: 
                case TOVERO_3: 
                case TOVERO_4: {
                    mappings.add(new AlleleDominanceMapping(Allele.TOBIANO, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    mappings.add(new AlleleDominanceMapping(Allele.OVERO, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    break;
                }
                case BADGER_FACE: {
                    break;
                }
                case BALD_FACE_1: 
                case BALD_FACE_2: {
                    mappings.add(new AlleleDominanceMapping(Allele.SPLASHED_WHITE, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    mappings.add(new AlleleDominanceMapping(Allele.TOBIANO, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    mappings.add(new AlleleDominanceMapping(Allele.OVERO, Dominance.DOMINANT));
                    mappings.add(new AlleleDominanceMapping(Allele.SABINO, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    break;
                }
                case BLAZE_1: 
                case BLAZE_2: 
                case BLAZE_3: {
                    mappings.add(new AlleleDominanceMapping(Allele.TOBIANO, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    mappings.add(new AlleleDominanceMapping(Allele.SPLASHED_WHITE, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    mappings.add(new AlleleDominanceMapping(Allele.SABINO, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    break;
                }
                case CRESCENT: {
                    break;
                }
                case SNIP: {
                    break;
                }
                case STAR_SNIP_1: {
                    break;
                }
                case STAR_SNIP_2: {
                    break;
                }
                case STAR_1: {
                    break;
                }
                case STAR_2: {
                    break;
                }
                case STRIPE_1: {
                    break;
                }
                case STRIPE_2: {
                    break;
                }
                case LEG_MARKINGS_1: 
                case LEG_MARKINGS_2: 
                case LEG_MARKINGS_3: 
                case LEG_MARKINGS_4: 
                case LEG_MARKINGS_5: 
                case LEG_MARKINGS_6: 
                case LEG_MARKINGS_7: 
                case LEG_MARKINGS_8: 
                case LEG_MARKINGS_9: {
                    mappings.add(new AlleleDominanceMapping(Allele.TOBIANO, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    mappings.add(new AlleleDominanceMapping(Allele.SPLASHED_WHITE, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                    mappings.add(new AlleleDominanceMapping(Allele.SABINO, HorseAlleleReverseEngineerSessionImpl.getRandomNonRecessive()));
                }
            }
        }
        return Collections.unmodifiableList(mappings);
    }

    private static Dominance getRandomNonDominant() {
        return ListUtils.getRandom(Dominance.DOMINANT, Dominance.RECESSIVE);
    }

    private static Dominance getRandomNonRecessive() {
        return ListUtils.getRandom(Dominance.HETEROZYGOUS, Dominance.DOMINANT);
    }

    private static Dominance getRandomDominance() {
        return ListUtils.getRandom(Dominance.values());
    }
}

