/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.heart;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.collector.ECCollectors;
import com.equestricraft.core.agesetting.AgeSettingSession;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.heart.HorseHeartRateProvider;
import java.time.Duration;

public class HorseHeartAccessor
extends AbstractHorseAccessor {
    private float currentBpmFactor = 1.0f;
    private float targetBpmFactor = 1.0f;
    private final CachedValue<Float> cachedBpmOffsetFactor = new CachedValue<Float>(this::getBpmFactor, Duration.ofMinutes(2L));
    @Service
    private static ServiceInstance<HorseHeartRateProvider> horseHeartRateProviders;
    @Service
    private static AgeSettingSession ageSettingSession;

    public HorseHeartAccessor(EQHorse horse) {
        super(horse);
    }

    public double getHeartRate() {
        return this.getTarget() * (double)this.getCurrentBpmFactor();
    }

    private double getTarget() {
        return ageSettingSession.getHeartRate(this.horse);
    }

    private float getCurrentBpmFactor() {
        return this.currentBpmFactor * this.cachedBpmOffsetFactor.get().floatValue();
    }

    public void setTargetBpmFactor(float value) {
        this.targetBpmFactor = value;
    }

    private float getBpmFactor() {
        return horseHeartRateProviders.stream().map(p -> Float.valueOf(p.getHeartRateFactor(this.horse))).collect(ECCollectors.toCombinedFloatPercentage()).floatValue();
    }

    @Override
    public void activeTick() {
        if (this.currentBpmFactor == this.targetBpmFactor) {
            return;
        }
        this.currentBpmFactor = this.currentBpmFactor < this.targetBpmFactor ? (this.currentBpmFactor += 0.05f) : (this.currentBpmFactor -= 0.05f);
    }
}

