/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.hoof;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.hoof.GroundType;
import com.equestricraft.core.horse.hoof.HorseHoofTractionStatProvider;
import java.time.Duration;

public class HorseHoovesAccessor
extends AbstractHorseAccessor {
    @Service
    private static ServiceInstance<HorseHoofTractionStatProvider> horseHoofTractionStatProviders;

    public HorseHoovesAccessor(EQHorse horse) {
        super(horse);
    }

    public void trim() {
        this.horse.setLastHoofTrim(System.currentTimeMillis());
        this.horse.save();
    }

    public int getLengthPercentage() {
        int maximumLengthDays = HorseSettings.getHoofMaximumLengthDays();
        long maximumLengthMillis = (long)maximumLengthDays * 86400000L;
        long millisSinceTrim = DateUtils.millisSince(this.horse.getLastHoofTrim());
        return (int)((double)millisSinceTrim / (double)maximumLengthMillis * 100.0);
    }

    public float getWear() {
        return (float)(this.horse.getHoofWearPercentage() / 100.0);
    }

    public void setWear(float value) {
        double percentage = (double)value * 100.0;
        this.horse.setHoofWearPercentage(NumberUtils.keepWithinRange(percentage, 0.0, 100.0));
        this.horse.save();
    }

    public void addWearForRideDuration(Duration duration) {
        double wearPerHour = HorseSettings.getHoofWearPercentagePerRideHour();
        double reductionFromShoe = this.horse.getShoes().getHoofWearReductionPercentage();
        wearPerHour = PercentageUtils.decreaseByPercentage(wearPerHour, reductionFromShoe);
        double hoursRidden = (double)duration.toMillis() / 3600000.0;
        float wearToAdd = (float)(hoursRidden * wearPerHour / 100.0);
        this.setWear(this.getWear() + wearToAdd);
    }

    public float getTractionValue(GroundType groundType) {
        float value = this.getBaseTraction(groundType);
        for (HorseHoofTractionStatProvider provider : horseHoofTractionStatProviders) {
            value *= provider.getTractionValue(this.horse, groundType);
        }
        return value;
    }

    private float getBaseTraction(GroundType groundType) {
        return switch (groundType) {
            default -> throw new IncompatibleClassChangeError();
            case GroundType.SOFT -> HorseSettings.getBaseSoftGroundTraction();
            case GroundType.HARD -> HorseSettings.getBaseHardGroundTraction();
            case GroundType.LOOSE -> HorseSettings.getBaseLooseGroundTraction();
        };
    }
}

