/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.horselog;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseLogDto;
import com.equestricraft.api.common.APIHorseLogsDto;
import com.equestricraft.api.common.APIHorseLogsSearchRequestDto;
import com.equestricraft.core.horse.horselog.HorseLogAccessor;
import com.equestricraft.core.horse.horselog.HorseLogInfo;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import groovy.lang.Closure;
import java.util.AbstractList;
import java.util.Date;
import java.util.List;

public class APIHorseLogsDtoImpl
extends AbstractList<APIHorseLogDto>
implements APIHorseLogsDto {
    private final HorseLogAccessor horseLogAccessor;
    private List<HorseLogInfo> allLogs = null;

    public APIHorseLogsDtoImpl(HorseLogAccessor horseLogAccessor) {
        this.horseLogAccessor = horseLogAccessor;
    }

    @Override
    public int getCountOfLogs(Closure<?> closure) {
        APIHorseLogsSearchRequestDto request = this.buildSearchRequest(closure);
        if (request.getPastDuration() != null) {
            return this.getCountOfLogs(request.getLogTypes(), request.getPastDuration());
        }
        return this.getCountOfLogs(request.getLogTypes(), request.getSince());
    }

    @Override
    public int getCountOfLogs(List<String> logTypes, APIDurationDto pastDuration) {
        return this.horseLogAccessor.getCountOfLogsInPastDuration(logTypes, pastDuration.getDuration());
    }

    @Override
    public int getCountOfLogs(List<String> logTypes, Date since) {
        return this.horseLogAccessor.getCountOfLogsSince(logTypes, since);
    }

    private APIHorseLogsSearchRequestDto buildSearchRequest(Closure<?> closure) {
        APIHorseLogsSearchRequestDto request = new APIHorseLogsSearchRequestDto();
        closure.setDelegate(request);
        closure.call();
        return request;
    }

    @Override
    public APIHorseLogDto get(int index) {
        this.ensureAllLogsLoaded();
        HorseLogInfo log = this.allLogs.get(index);
        return new APIHorseLogDto(new APIPlayerDtoImpl(log.player()), null, log.time(), log.type().name(), log.message());
    }

    @Override
    public int size() {
        this.ensureAllLogsLoaded();
        return this.allLogs.size();
    }

    private void ensureAllLogsLoaded() {
        if (this.allLogs == null) {
            this.allLogs = this.horseLogAccessor.getAll();
        }
    }
}

