/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.horselog;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseLogType;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.horselog.HorseLogInfo;
import com.equestricraft.core.horse.horselog.HorseLogSearchDto;
import com.equestricraft.core.horse.horselog.HorseLogSession;
import com.equestricraft.core.player.ECPlayer;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class HorseLogAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseLogSession horseLogSession;

    public HorseLogAccessor(EQHorse horse) {
        super(horse);
    }

    public void log(ECPlayer player, HorseLogType type, String message, Object ... params) {
        horseLogSession.logHorseEvent(this.horse.getId(), player, type, message, params);
    }

    public int getCountOfLogsInPastDuration(List<String> logTypes, Duration pastDuration) {
        return this.getCountOfLogsSince(logTypes, DateUtils.futureDurationOffset(pastDuration.negated()));
    }

    public int getCountOfLogsSince(List<String> logTypes, Date since) {
        HorseLogSearchDto search = new HorseLogSearchDto(this.horse.getId(), null, this.buildLogTypesList(logTypes), since);
        return horseLogSession.getCountOfLogs(search);
    }

    private List<HorseLogType> buildLogTypesList(List<String> logTypes) {
        if (logTypes == null || logTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return logTypes.stream().map(HorseLogType::valueOf).toList();
    }

    public List<HorseLogInfo> getAll() {
        return horseLogSession.retrieveLogsForHorse(this.horse.getId());
    }
}

