/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.horselog;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.HorseLogType;
import com.equestricraft.core.horse.horselog.HorseLog;
import java.util.List;

public class HorseLogDatabase
implements RepositoryDatasource<HorseLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_LOG_TYPE = "LOG_TYPE";
    private static final String COLUMN_MESSAGE = "MESSAGE";

    @Override
    public void create(HorseLog horseLog) {
        Query.insertInto("HORSE_LOG").columns(QueryColumn.column(COLUMN_HORSE_ID, horseLog.getHorseId()), QueryColumn.column(COLUMN_PLAYER_ID, horseLog.getPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, horseLog.getTimeStamp()), QueryColumn.column(COLUMN_LOG_TYPE, horseLog.getLogType()), QueryColumn.column(COLUMN_MESSAGE, horseLog.getMessage())).executeGetGeneratedKey(horseLog::setId);
    }

    @Override
    public List<HorseLog> retrieveAll() {
        return Query.selectAllFrom("HORSE_LOG").getList(this::getFromResultRow);
    }

    private HorseLog getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        HorseLogType logType = row.getEnum(COLUMN_LOG_TYPE, HorseLogType.class);
        String message = row.getString(COLUMN_MESSAGE);
        return new HorseLog(id, horseId, playerId, timeStamp, logType, message);
    }
}

