/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.horselog;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseLogType;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.horse.horselog.HorseLog;
import com.equestricraft.core.horse.horselog.HorseLogDatabase;
import com.equestricraft.core.horse.horselog.HorseLogSearchDto;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class HorseLogRepository
extends Repository<HorseLog, Integer> {
    @Service
    private HorseLogDatabase horseLogDatabase;

    @Override
    protected RepositoryDatasource<HorseLog, Integer> getDatasource() {
        return this.horseLogDatabase;
    }

    @Override
    protected Function<HorseLog, Object> getIndexFunction() {
        return HorseLog::getHorseId;
    }

    public List<HorseLog> findLogsByHorseId(int horseId) {
        return this.findListByIndexKey(horseId);
    }

    public List<HorseLog> findLogsByPlayerId(int playerId) {
        return this.findListByPredicates((T l) -> l.getPlayerId() == playerId);
    }

    public List<HorseLog> searchHorseLog(HorseLogSearchDto horseLogSearchDto) {
        RepositorySearchQuery<HorseLog> searchQuery = this.createSearchQuery();
        if (horseLogSearchDto.horseId() != null) {
            searchQuery.filter(l -> l.getHorseId() == horseLogSearchDto.horseId().intValue());
        }
        if (horseLogSearchDto.playerId() != null) {
            searchQuery.filter(l -> l.getPlayerId() == horseLogSearchDto.playerId().intValue());
        }
        if (ListUtils.isNotEmpty(horseLogSearchDto.logTypes())) {
            Predicate<HorseLog> logPredicate = null;
            for (HorseLogType logType : horseLogSearchDto.logTypes()) {
                Predicate<HorseLog> p = l -> l.getLogType().equals((Object)logType);
                if (logPredicate == null) {
                    logPredicate = p;
                    continue;
                }
                logPredicate = logPredicate.or(p);
            }
            searchQuery.filter(logPredicate);
        }
        if (horseLogSearchDto.since() != null) {
            searchQuery.filter(l -> l.getTimeStamp() >= horseLogSearchDto.since().getTime());
        }
        return searchQuery.many();
    }
}

