/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.horselog;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseLogType;
import com.equestricraft.core.horse.horselog.HorseLog;
import com.equestricraft.core.horse.horselog.HorseLogInfo;
import com.equestricraft.core.horse.horselog.HorseLogRepository;
import com.equestricraft.core.horse.horselog.HorseLogSearchDto;
import com.equestricraft.core.horse.horselog.HorseLogSearchSession;
import com.equestricraft.core.horse.horselog.HorseLogSession;
import com.equestricraft.core.horse.horselog.HorseLogTransformer;
import com.equestricraft.core.player.ECPlayer;
import java.text.MessageFormat;
import java.util.List;

public class HorseLogSessionImpl
implements HorseLogSession {
    @Service
    private HorseLogRepository horseLogRepository;
    @Service
    private HorseLogTransformer horseLogTransformer;
    @Service
    private HorseLogSearchSession horseLogSearchSession;

    @Override
    public void logHorseEvent(int horseId, ECPlayer player, HorseLogType logType, String message, Object ... params) {
        TaskScheduler.executeAsyncTask(() -> this.logEventImpl(horseId, player, logType, message, params));
    }

    private void logEventImpl(int horseId, ECPlayer player, HorseLogType logType, String message, Object[] params) {
        message = MessageFormat.format(message, params);
        HorseLog horseLog = new HorseLog(0, horseId, player.getId(), System.currentTimeMillis(), logType, message);
        this.horseLogRepository.add(horseLog);
    }

    @Override
    public List<HorseLogInfo> retrieveLogsForHorse(int horseId) {
        List<HorseLog> logs = this.horseLogRepository.findLogsByHorseId(horseId);
        return this.horseLogTransformer.transformHorseLogsToInfoList(logs);
    }

    @Override
    public List<HorseLogInfo> retrieveLogsForPlayer(int playerId) {
        List<HorseLog> logs = this.horseLogRepository.findLogsByPlayerId(playerId);
        return this.horseLogTransformer.transformHorseLogsToInfoList(logs);
    }

    @Override
    public int getCountOfLogs(HorseLogSearchDto horseLogSearchDto) {
        return this.horseLogSearchSession.countHorseLogs(horseLogSearchDto);
    }
}

