/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseIllnessDto;
import com.equestricraft.api.common.APIIllnessDto;
import com.equestricraft.api.common.APIIllnessEffectDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.horse.illness.IllnessHorseUpdateSession;
import com.equestricraft.core.illness.APIIllnessDtoImpl;
import com.equestricraft.core.illness.APIIllnessEffectDtoImpl;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessEffect;
import groovy.lang.Closure;
import java.time.Duration;
import java.util.List;
import java.util.UUID;

public class APIHorseIllnessDtoImpl
implements APIHorseIllnessDto {
    private final IllnessHorse illnessHorse;
    @Service
    private static IllnessHorseUpdateSession illnessHorseUpdateSession;

    public APIHorseIllnessDtoImpl(IllnessHorse illnessHorse) {
        this.illnessHorse = illnessHorse;
    }

    @Override
    public APIIllnessDto getIllness() {
        Illness illness = this.illnessHorse.getIllness();
        return new APIIllnessDtoImpl(illness);
    }

    @Override
    public List<APIIllnessEffectDto> getEffects() {
        Illness illness = this.illnessHorse.getIllness();
        List<UUID> effectIds = this.illnessHorse.getActiveEffectIds();
        return illness.getIllnessEffects().stream().filter(e -> effectIds.contains(e.getId())).map(e -> new APIIllnessEffectDtoImpl((IllnessEffect)e)).toList();
    }

    @Override
    public APIDurationDto getEffectiveDurationIntoIllness() {
        if (this.isCured()) {
            return null;
        }
        Duration duration = this.illnessHorse.getEffectiveDurationHad();
        return new APIDurationDto(duration);
    }

    @Override
    public boolean isCured() {
        return this.illnessHorse.isCured();
    }

    @Override
    public boolean isActive() {
        return !this.isCured();
    }

    @Override
    public APIDurationDto getDurationSinceCured() {
        if (this.isCured()) {
            Duration durationSinceCured = DateUtils.durationSince(this.illnessHorse.getCureTime());
            return new APIDurationDto(durationSinceCured);
        }
        return null;
    }

    @Override
    public String getNote() {
        return this.illnessHorse.getNotes();
    }

    @Override
    public void setNote(String note) {
        this.illnessHorse.setNotes(note);
        this.illnessHorse.save();
    }

    @Override
    public APIDurationDto getTimeAdvancementOffsetDuration() {
        Duration duration = Duration.ofHours(this.illnessHorse.getTimeAdvancementOffsetHours());
        return new APIDurationDto(duration);
    }

    @Override
    public void setTimeAdvancementOffsetDuration(APIDurationDto duration) {
        this.illnessHorse.setTimeAdvancementOffsetHours(duration.getHours());
        this.illnessHorse.save();
    }

    @Override
    public void timeAdvancementOffsetDuration(Closure<?> closure) {
        APIDurationDto duration = new APIDurationDto();
        closure.setDelegate(duration);
        closure.call();
        this.setTimeAdvancementOffsetDuration(duration);
    }

    @Override
    public void incrementTimeAdvancementDuration(Closure<?> closure) {
        APIDurationDto duration = new APIDurationDto();
        closure.setDelegate(duration);
        closure.call();
        this.illnessHorse.addTimeAdvancementOffsetHours(Math.toIntExact(duration.getDuration().toHours()));
    }

    @Override
    public void decrementTimeAdvancementDuration(Closure<?> closure) {
        APIDurationDto duration = new APIDurationDto();
        closure.setDelegate(duration);
        closure.call();
        this.illnessHorse.subtractTimeAdvancementOffsetHours(Math.toIntExact(duration.getDuration().toHours()));
    }

    @Override
    public double getTimeAdvancementFactor() {
        return this.illnessHorse.getTimeAdvancementFactor();
    }

    @Override
    public void setTimeAdvancementFactor(double factor) {
        this.illnessHorse.setTimeAdvancementFactor(factor);
        this.illnessHorse.save();
    }

    @Override
    public void timeAdvancementFactor(double factor) {
        this.setTimeAdvancementFactor(factor);
    }

    @Override
    public void incrementTimeAdvancementFactor(double amount) {
        this.illnessHorse.increaseTimeAdvancementFactor(amount);
    }

    @Override
    public void decrementTimeAdvancementFactor(double amount) {
        this.illnessHorse.decreaseTimeAdvancementFactor(amount);
    }

    @Override
    public void makeAware() {
        this.illnessHorse.makeAware();
    }

    @Override
    public void cure() {
        illnessHorseUpdateSession.cureIllness(this.illnessHorse);
    }
}

