/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.api.common.APIHorseIllnessDto;
import com.equestricraft.api.common.APIHorseIllnessImmunityDto;
import com.equestricraft.api.common.APIHorseIllnessesDto;
import com.equestricraft.api.common.APIIllnessDto;
import com.equestricraft.api.common.APIIllnessesUncuredDto;
import com.equestricraft.core.horse.illness.APIHorseIllnessDtoImpl;
import com.equestricraft.core.horse.illness.APIIllnessesUncuredDtoImpl;
import com.equestricraft.core.horse.illness.HorseIllnessAccessor;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.horse.illness.immunity.APIHorseIllnessImmunityDtoImpl;
import java.util.AbstractList;
import java.util.List;
import java.util.Optional;

public class APIHorseIllnessesDtoImpl
extends AbstractList<APIHorseIllnessDto>
implements APIHorseIllnessesDto {
    private final HorseIllnessAccessor horseIllnessAccessor;
    private List<IllnessHorse> allIllnesses = null;

    public APIHorseIllnessesDtoImpl(HorseIllnessAccessor horseIllnessAccessor) {
        this.horseIllnessAccessor = horseIllnessAccessor;
    }

    @Override
    public void give(APIIllnessDto illness) {
        this.horseIllnessAccessor.giveIllness(illness.getId());
    }

    @Override
    public APIHorseIllnessDto getIllness(APIIllnessDto illness) {
        Optional<IllnessHorse> illnessHorse = this.horseIllnessAccessor.getCurrentRecordForIllness(illness.getId());
        return illnessHorse.map(APIHorseIllnessDtoImpl::new).orElse(null);
    }

    @Override
    public APIIllnessesUncuredDto getUncured() {
        return new APIIllnessesUncuredDtoImpl(this.horseIllnessAccessor.getUncured());
    }

    @Override
    public APIHorseIllnessImmunityDto getImmunity(APIIllnessDto illness) {
        return new APIHorseIllnessImmunityDtoImpl(this.horseIllnessAccessor.getImmunity(illness.getId()));
    }

    @Override
    public boolean isHasDeadly() {
        return this.horseIllnessAccessor.hasDeadlyIllness();
    }

    @Override
    public APIHorseIllnessDto get(int index) {
        this.ensureLoaded();
        IllnessHorse illnessHorse = this.allIllnesses.get(index);
        return new APIHorseIllnessDtoImpl(illnessHorse);
    }

    @Override
    public int size() {
        this.ensureLoaded();
        return this.allIllnesses.size();
    }

    private void ensureLoaded() {
        if (this.allIllnesses == null) {
            this.allIllnesses = this.horseIllnessAccessor.getAll();
        }
    }
}

