/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.api.common.APIHorseIllnessDto;
import com.equestricraft.api.common.APIIllnessDto;
import com.equestricraft.api.common.APIIllnessesUncuredDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.horse.illness.APIHorseIllnessDtoImpl;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.illness.APIIllnessDtoImpl;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessRepository;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class APIIllnessesUncuredDtoImpl
extends MapAdapter<APIIllnessDto, APIHorseIllnessDto>
implements APIIllnessesUncuredDto {
    private final List<IllnessHorse> uncured;
    @Service
    private static IllnessRepository illnessRepository;

    public APIIllnessesUncuredDtoImpl(List<IllnessHorse> uncured) {
        this.uncured = uncured;
    }

    @Override
    public APIHorseIllnessDto get(Object key) {
        Illness illness = this.getFromKey(key);
        return this.uncured.stream().filter(i -> i.getIllness().equals(illness)).map(i -> new APIHorseIllnessDtoImpl((IllnessHorse)i)).findFirst().orElse(null);
    }

    @Override
    public boolean containsKey(Object key) {
        Illness illness = this.getFromKey(key);
        return this.uncured.stream().anyMatch(i -> i.getIllness().equals(illness));
    }

    private Illness getFromKey(Object key) {
        if (key instanceof String) {
            String identifier = (String)key;
            return illnessRepository.findByIdentifier(identifier).orElseThrow();
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return (Illness)illnessRepository.findByKey(id);
        }
        if (key instanceof APIIllnessDtoImpl) {
            APIIllnessDtoImpl apiIllnessDto = (APIIllnessDtoImpl)key;
            return apiIllnessDto.getIllness();
        }
        throw new IllegalArgumentException("Invalid key provided");
    }

    @Override
    public int size() {
        return this.uncured.size();
    }

    @Override
    public Set<Map.Entry<APIIllnessDto, APIHorseIllnessDto>> entrySet() {
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<APIIllnessDto, APIHorseIllnessDto>> {
        EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry mapEntry = (Map.Entry)o;
                Object key = mapEntry.getKey();
                APIHorseIllnessDto currentEntry = APIIllnessesUncuredDtoImpl.this.get(key);
                return currentEntry != null && currentEntry.equals(mapEntry.getValue());
            }
            return false;
        }

        @Override
        public boolean add(Map.Entry<APIIllnessDto, APIHorseIllnessDto> apiIllnessDtoAPIHorseIllnessDtoEntry) {
            throw new UnsupportedOperationException("Cannot add an uncured illness to a horse this way");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Cannot remove an uncured illness from a horse this way");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Cannot remove an uncured illness from a horse this way");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Cannot clear a horses uncured illnesses");
        }

        @Override
        public Iterator<Map.Entry<APIIllnessDto, APIHorseIllnessDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return APIIllnessesUncuredDtoImpl.this.uncured.size();
        }

        final class EntrySetIterator
        implements Iterator<Map.Entry<APIIllnessDto, APIHorseIllnessDto>> {
            private final Iterator<IllnessHorse> iterator;

            EntrySetIterator() {
                this.iterator = APIIllnessesUncuredDtoImpl.this.uncured.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<APIIllnessDto, APIHorseIllnessDto> next() {
                IllnessHorse next = this.iterator.next();
                APIHorseIllnessDtoImpl dto = new APIHorseIllnessDtoImpl(next);
                return Map.entry(dto.getIllness(), dto);
            }
        }
    }
}

