/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.IllnessSeverity;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.horse.illness.IllnessHorseAdapter;
import com.equestricraft.core.horse.illness.IllnessHorseEngine;
import com.equestricraft.core.horse.illness.IllnessHorseRepository;
import com.equestricraft.core.horse.illness.IllnessHorseUpdateSession;
import com.equestricraft.core.horse.illness.immunity.HorseIllnessImmunityAccessor;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessEffect;
import com.equestricraft.core.illness.IllnessRepository;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class HorseIllnessAccessor
extends AbstractHorseAccessor {
    @Service
    private static IllnessHorseRepository illnessHorseRepository;
    @Service
    private static IllnessRepository illnessRepository;
    @Service
    private static IllnessHorseEngine illnessHorseEngine;
    @Service
    private static IllnessHorseUpdateSession illnessHorseUpdateSession;

    public HorseIllnessAccessor(EQHorse horse) {
        super(horse);
    }

    public void giveIllness(int illnessId) {
        illnessHorseEngine.giveIllnessToHorse(this.horse, illnessId);
    }

    public Optional<IllnessHorse> getCurrentRecordForIllness(int illnessId) {
        return illnessHorseRepository.findMostRecentRecordForHorseAndIllness(this.horse.getId(), illnessId).filter(IllnessHorse::isUncured);
    }

    public List<IllnessHorse> getUncured() {
        return illnessHorseRepository.findUncuredRecordsForHorse(this.horse.getId());
    }

    public List<IllnessHorse> getUncuredOwnerIsAwareOf() {
        return this.getUncured().stream().filter(IllnessHorse::isAware).toList();
    }

    public List<IllnessHorse> getAll() {
        return illnessHorseRepository.findByHorse(this.horse.getId());
    }

    public boolean hasIllness(int illnessId) {
        Optional<IllnessHorse> illnessHorse = this.getCurrentRecordForIllness(illnessId);
        return illnessHorse.map(IllnessHorse::isUncured).orElse(false);
    }

    public boolean hasDeadlyIllness() {
        List<IllnessHorse> illnessInfoList = this.getUncured();
        return illnessInfoList.stream().map(IllnessHorseAdapter::getActiveEffects).flatMap(Collection::stream).anyMatch(e -> e.getKillPercentageProbability() > 0.0);
    }

    public HorseIllnessImmunityAccessor getImmunity(int illnessId) {
        Illness illness = (Illness)illnessRepository.findByKey(illnessId);
        return new HorseIllnessImmunityAccessor(this.horse, illness);
    }

    public boolean hasUncuredAwareIllnesses() {
        return !this.getUncuredOwnerIsAwareOf().isEmpty();
    }

    public Optional<IllnessSeverity> getCurrentIllnessSeverity() {
        return this.getUncured().stream().flatMap(i -> i.getActiveEffects().stream()).map(IllnessEffect::getSeverity).min(Comparator.comparingInt(Enum::ordinal));
    }

    public void increaseCurePercentage(Illness illness, int percentageIncrease) {
        Optional<IllnessHorse> illnessHorse = this.getCurrentRecordForIllness(illness.getId());
        illnessHorse.ifPresent(ih -> this.updateCurePercentage((IllnessHorse)ih, percentageIncrease));
    }

    private void updateCurePercentage(IllnessHorse illnessHorse, int percentageIncrease) {
        int newPercentage = Math.min(illnessHorse.getCurePercentage() + percentageIncrease, 100);
        illnessHorse.setCurePercentage(newPercentage);
        illnessHorse.save();
        if (newPercentage == 100) {
            illnessHorseUpdateSession.cureIllness(illnessHorse);
        }
    }

    public boolean makeAwareOfIllness(Illness illness) {
        return this.getCurrentRecordForIllness(illness.getId()).map(IllnessHorse::makeAware).orElse(false);
    }

    public boolean addNoteToIllness(Illness illness, String note) {
        Optional<IllnessHorse> illnessHorse = this.getCurrentRecordForIllness(illness.getId());
        if (illnessHorse.isPresent()) {
            IllnessHorse ih = illnessHorse.get();
            this.addNotesToIllnessRecord(ih, note);
            return true;
        }
        return false;
    }

    private void addNotesToIllnessRecord(IllnessHorse illnessHorse, String note) {
        illnessHorse.setNotes(note);
        illnessHorse.save();
    }
}

