/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.common.util.ProbabilityUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.HorseAction;
import com.equestricraft.core.horse.action.HorseActionRejecter;
import com.equestricraft.core.horse.symptom.HorseSymptom;
import com.equestricraft.core.illness.symptom.IllnessSymptomActionPercentage;
import java.util.List;

public class IllnessActionRejecter
implements HorseActionRejecter {
    @Override
    public boolean shouldReject(EQHorse horse, HorseAction<?> action) {
        List<HorseSymptom> symptoms = horse.getSymptoms().getActive();
        for (HorseSymptom symptom : symptoms) {
            Double percentageForAction = symptom.getSymptom().getActionPercentages().stream().filter(a -> a.getActionIdentifier().equals(action.getIdentifier())).findFirst().map(IllnessSymptomActionPercentage::getPercentage).orElse(0.0);
            double resultPercentage = PercentageUtils.of((double)percentageForAction, symptom.getPercentage());
            if (!ProbabilityUtils.testPercentageProbability(resultPercentage)) continue;
            return true;
        }
        return false;
    }
}

