/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.common.IllnessSeverity;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.health.HorseHealth;
import com.equestricraft.core.horse.health.HorseHealthStatusProvider;

public class IllnessHeathStatusProvider
implements HorseHealthStatusProvider {
    @Override
    public HorseHealth getHealthStatus(EQHorse horse) {
        return horse.getIllness().getCurrentIllnessSeverity().map(this::toHealthStatus).orElse(HorseHealth.GREEN);
    }

    private HorseHealth toHealthStatus(IllnessSeverity illnessSeverity) {
        return switch (illnessSeverity) {
            default -> throw new IncompatibleClassChangeError();
            case IllnessSeverity.NONE -> HorseHealth.GREEN;
            case IllnessSeverity.MINOR -> HorseHealth.AMBER;
            case IllnessSeverity.MAJOR -> HorseHealth.RED;
        };
    }
}

