/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.illness.IllnessHorseAdapter;
import com.equestricraft.core.horse.illness.IllnessHorseRepository;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class IllnessHorse
extends IllnessHorseAdapter
implements RepositoryEntity<Integer> {
    private int id;
    private final int illnessId;
    private final int horseId;
    private final long startTime;
    private int timeAdvancementOffsetHours;
    private double timeAdvancementFactor;
    private Long diagnosisTime;
    private int curePercentage;
    private Long cureTime;
    private String notes;
    private List<UUID> activeEffectIds;

    public IllnessHorse(int id, int illnessId, int horseId, long startTime, int timeAdvancementOffsetHours, double timeAdvancementFactor, Long diagnosisTime, int curePercentage, Long cureTime, String notes, List<UUID> activeEffectIds) {
        this.id = id;
        this.illnessId = illnessId;
        this.horseId = horseId;
        this.startTime = startTime;
        this.timeAdvancementOffsetHours = timeAdvancementOffsetHours;
        this.timeAdvancementFactor = timeAdvancementFactor;
        this.diagnosisTime = diagnosisTime;
        this.curePercentage = curePercentage;
        this.cureTime = cureTime;
        this.notes = notes;
        this.activeEffectIds = activeEffectIds;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getIllnessId() {
        return this.illnessId;
    }

    public int getHorseId() {
        return this.horseId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getTimeAdvancementOffsetHours() {
        return this.timeAdvancementOffsetHours;
    }

    public void setTimeAdvancementOffsetHours(int timeAdvancementOffsetHours) {
        this.timeAdvancementOffsetHours = timeAdvancementOffsetHours;
    }

    public double getTimeAdvancementFactor() {
        return this.timeAdvancementFactor;
    }

    public void setTimeAdvancementFactor(double timeAdvancementFactor) {
        this.timeAdvancementFactor = timeAdvancementFactor;
    }

    public Long getDiagnosisTime() {
        return this.diagnosisTime;
    }

    public boolean isAware() {
        return this.getDiagnosisTime() != null;
    }

    public boolean isNotAware() {
        return !this.isAware();
    }

    public void setDiagnosisTime(Long diagnosisTime) {
        this.diagnosisTime = diagnosisTime;
    }

    public int getCurePercentage() {
        return this.curePercentage;
    }

    public void setCurePercentage(int curePercentage) {
        this.curePercentage = curePercentage;
    }

    public Long getCureTime() {
        return this.cureTime;
    }

    public boolean isCured() {
        return this.getCureTime() != null;
    }

    public boolean isUncured() {
        return !this.isCured();
    }

    public void setCureTime(Long cureTime) {
        this.cureTime = cureTime;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public List<UUID> getActiveEffectIds() {
        return this.activeEffectIds;
    }

    public void setActiveEffectIds(List<UUID> activeEffectIds) {
        this.activeEffectIds = activeEffectIds;
    }

    public Duration getEffectiveDurationHad() {
        long millisHad = DateUtils.millisSince(this.getStartTime());
        double factor = this.getTimeAdvancementFactor();
        millisHad = (int)((double)millisHad * factor);
        return Duration.ofMillis(millisHad += (long)this.getTimeAdvancementOffsetHours() * 3600000L);
    }

    public void addTimeAdvancementOffsetHours(int toAdd) {
        IllnessHorse.ensurePositive(toAdd);
        this.alterTimeAdvancementOffsetHours(toAdd);
    }

    public void subtractTimeAdvancementOffsetHours(int toRemove) {
        IllnessHorse.ensurePositive(toRemove);
        this.alterTimeAdvancementOffsetHours(-toRemove);
    }

    private void alterTimeAdvancementOffsetHours(int value) {
        if (this.isUncured()) {
            int newValue = this.getTimeAdvancementOffsetHours() + value;
            this.setTimeAdvancementOffsetHours(newValue);
            this.save();
        }
    }

    public void increaseTimeAdvancementFactor(double toAdd) {
        IllnessHorse.ensurePositive(toAdd);
        this.alterTimeAdvancementFactor(toAdd);
    }

    public void decreaseTimeAdvancementFactor(double toRemove) {
        IllnessHorse.ensurePositive(toRemove);
        this.alterTimeAdvancementFactor(-toRemove);
    }

    private void alterTimeAdvancementFactor(double value) {
        if (this.isUncured()) {
            double newValue = this.getTimeAdvancementFactor() + value;
            this.setTimeAdvancementFactor(newValue);
            this.save();
        }
    }

    private static void ensurePositive(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Must be a positive value");
        }
    }

    public boolean makeAware() {
        if (this.isAware()) {
            return false;
        }
        long time = System.currentTimeMillis();
        this.setDiagnosisTime(time);
        this.save();
        return true;
    }

    @Override
    public void save() {
        Services.getService(IllnessHorseRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IllnessHorse that = (IllnessHorse)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

