/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessEffect;
import com.equestricraft.core.illness.IllnessRepository;
import java.util.List;
import java.util.UUID;

public abstract class IllnessHorseAdapter {
    @Service
    private static IllnessRepository illnessRepository;
    private final CachedValue<Illness> illness = CachedValue.build(() -> (Illness)illnessRepository.findByKey(this.getIllnessId())).expiredIfOlderThanDuration(illnessRepository::getDurationSinceLastLoad).complete();

    public abstract int getIllnessId();

    public abstract List<UUID> getActiveEffectIds();

    public final Illness getIllness() {
        return this.illness.get();
    }

    public final List<IllnessEffect> getActiveEffects() {
        return this.getIllness().getIllnessEffects().stream().filter(e -> this.getActiveEffectIds().contains(e.getId())).toList();
    }
}

