/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.illness.IllnessHorse;
import java.util.List;
import java.util.UUID;

public class IllnessHorseDatabase
implements RepositoryDatasource<IllnessHorse, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_ILLNESS_ID = "ILLNESS_ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_START_TIME = "START_TIME";
    private static final String COLUMN_TIME_ADVANCEMENT_OFFSET_HOURS = "TIME_ADVANCEMENT_OFFSET_HOURS";
    private static final String COLUMN_TIME_ADVANCEMENT_FACTOR = "TIME_ADVANCEMENT_FACTOR";
    private static final String COLUMN_DIAGNOSES_TIME = "DIAGNOSIS_TIME";
    private static final String COLUMN_CURE_PERCENTAGE = "CURE_PERCENTAGE";
    private static final String COLUMN_CURE_TIME = "CURE_TIME";
    private static final String COLUMN_NOTES = "NOTES";
    private static final String COLUMN_ILLNESS_HORSE_ID = "ILLNESS_HORSE_ID";
    private static final String COLUMN_EFFECT_ID = "EFFECT_ID";

    @Override
    public void create(IllnessHorse illnessHorse) {
        Query.insertInto("ILLNESS_HORSE").columns(QueryColumn.column(COLUMN_ILLNESS_ID, illnessHorse.getIllnessId()), QueryColumn.column(COLUMN_HORSE_ID, illnessHorse.getHorseId()), QueryColumn.column(COLUMN_START_TIME, illnessHorse.getStartTime()), QueryColumn.column(COLUMN_TIME_ADVANCEMENT_OFFSET_HOURS, illnessHorse.getTimeAdvancementOffsetHours()), QueryColumn.column(COLUMN_TIME_ADVANCEMENT_FACTOR, illnessHorse.getTimeAdvancementFactor()), QueryColumn.column(COLUMN_DIAGNOSES_TIME, illnessHorse.getDiagnosisTime()), QueryColumn.column(COLUMN_CURE_PERCENTAGE, illnessHorse.getCurePercentage())).executeGetGeneratedKey(illnessHorse::setId);
        this.addIllnessHorseEffects(illnessHorse);
    }

    @Override
    public List<IllnessHorse> retrieveAll() {
        return Query.selectAllFrom("ILLNESS_HORSE").getList(this::getIllnessHorseFromResultRow);
    }

    private IllnessHorse getIllnessHorseFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int illnessId = row.getInt(COLUMN_ILLNESS_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        long startTime = row.getLong(COLUMN_START_TIME);
        int timeAdvancementOffsetHours = row.getInt(COLUMN_TIME_ADVANCEMENT_OFFSET_HOURS);
        double timeAdvancementFactor = row.getDouble(COLUMN_TIME_ADVANCEMENT_FACTOR);
        Long diagnosisTime = row.getNullableLong(COLUMN_DIAGNOSES_TIME);
        int curePercentage = row.getInt(COLUMN_CURE_PERCENTAGE);
        Long cureTime = row.getNullableLong(COLUMN_CURE_TIME);
        String notes = row.getNullableString(COLUMN_NOTES);
        List<UUID> activeEffectIds = this.getActiveEffectIdsForIllnessHorse(id);
        return new IllnessHorse(id, illnessId, horseId, startTime, timeAdvancementOffsetHours, timeAdvancementFactor, diagnosisTime, curePercentage, cureTime, notes, activeEffectIds);
    }

    private List<UUID> getActiveEffectIdsForIllnessHorse(int id) {
        return Query.selectAllFrom("ILLNESS_HORSE_EFFECT").where(QueryColumn.column(COLUMN_ILLNESS_HORSE_ID, id)).getList(r -> r.getUuid(COLUMN_EFFECT_ID));
    }

    @Override
    public void update(IllnessHorse illnessHorse) {
        Query.update("ILLNESS_HORSE").set(QueryColumn.column(COLUMN_TIME_ADVANCEMENT_OFFSET_HOURS, illnessHorse.getTimeAdvancementOffsetHours()), QueryColumn.column(COLUMN_TIME_ADVANCEMENT_FACTOR, illnessHorse.getTimeAdvancementFactor()), QueryColumn.column(COLUMN_CURE_TIME, illnessHorse.getCureTime()), QueryColumn.column(COLUMN_DIAGNOSES_TIME, illnessHorse.getDiagnosisTime()), QueryColumn.column(COLUMN_CURE_PERCENTAGE, illnessHorse.getCurePercentage()), QueryColumn.column(COLUMN_NOTES, illnessHorse.getNotes())).where(QueryColumn.column(COLUMN_ID, illnessHorse.getId())).execute();
        Query.deleteFrom("ILLNESS_HORSE_EFFECT").where(QueryColumn.column(COLUMN_ILLNESS_HORSE_ID, illnessHorse.getId())).execute();
        this.addIllnessHorseEffects(illnessHorse);
    }

    private void addIllnessHorseEffects(IllnessHorse illnessHorse) {
        for (UUID effect : illnessHorse.getActiveEffectIds()) {
            Query.insertInto("ILLNESS_HORSE_EFFECT").columns(QueryColumn.column(COLUMN_ILLNESS_HORSE_ID, illnessHorse.getId()), QueryColumn.column(COLUMN_EFFECT_ID, effect)).execute();
        }
    }
}

