/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.api.common.APIHorseDto;
import com.equestricraft.api.common.APIHorseIllnessDto;
import com.equestricraft.base.database.DatabaseTransactionHelper;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.TriLock;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.common.util.ProbabilityUtils;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.death.HorseDeadException;
import com.equestricraft.core.horse.illness.IllnessEffectEndAction;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.horse.illness.IllnessHorseEngine;
import com.equestricraft.core.horse.illness.IllnessHorseRepository;
import com.equestricraft.core.horse.illness.IllnessHorseSession;
import com.equestricraft.core.horse.illness.IllnessHorseUpdateSession;
import com.equestricraft.core.horse.illness.ManualIllnessQueue;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessEffect;
import com.equestricraft.core.illness.IllnessRepository;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import com.equestricraft.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collector;

public class IllnessHorseEngineImpl
implements IllnessHorseEngine {
    @Service
    private HorseRepository horseRepository;
    @Service
    private IllnessHorseSession illnessHorseSession;
    @Service
    private IllnessHorseRepository illnessHorseRepository;
    @Service
    private IllnessRepository illnessRepository;
    @Service
    private IllnessHorseUpdateSession illnessHorseUpdateSession;
    @Service
    private HorseTransformer horseTransformer;
    private final ManualIllnessQueue manualIllnessQueue = ManualIllnessQueue.getInstance();
    private final TriLock illnessCheckLock = new TriLock();
    private static final Log log = Log.getLogger(IllnessHorseEngineImpl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performIllnessChecks() {
        if (FeatureFlag.ILLNESSES.isDisabled()) {
            return;
        }
        this.illnessCheckLock.exclusiveLock();
        try {
            List<EQHorse> horses = this.horseRepository.findAllLivingHorses();
            DatabaseTransactionHelper.startDatabaseTransaction();
            for (EQHorse horse : horses) {
                if (!horse.isImmortal() && horse.isOwnedByPlayer()) {
                    this.giveNewIllnesses(horse);
                }
                this.progressExistingIllnesses(horse);
            }
            DatabaseTransactionHelper.commitDatabaseTransaction();
        }
        catch (Exception ex) {
            log.error("Error performing illness check", ex);
            DatabaseTransactionHelper.rollbackDatabaseTransaction();
        }
        finally {
            this.illnessCheckLock.unlock();
            this.processManualQueue();
        }
    }

    private void giveNewIllnesses(EQHorse horse) {
        long giveTime = System.currentTimeMillis();
        List<Illness> illnessesToGiveToHorse = this.illnessHorseSession.retrieveIllnessesHorseCanGet(horse);
        if (ListUtils.isNotEmpty(illnessesToGiveToHorse)) {
            List<IllnessHorse> newIllnessesForHorses = illnessesToGiveToHorse.stream().map(illness -> this.createNewIllnessHorseRecord((Illness)illness, horse, giveTime)).toList();
            this.illnessHorseRepository.add(newIllnessesForHorses);
            illnessesToGiveToHorse.forEach(i -> this.executeOnApplyScript((Illness)i, horse));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshIllnessRecords() {
        if (FeatureFlag.ILLNESSES.isDisabled()) {
            return;
        }
        this.illnessCheckLock.exclusiveLock();
        long startTime = System.currentTimeMillis();
        try {
            log.debug("Refreshing all illness records");
            List<EQHorse> horses = this.horseRepository.findAllLivingHorses();
            DatabaseTransactionHelper.startDatabaseTransaction();
            horses.forEach(this::progressExistingIllnesses);
            DatabaseTransactionHelper.commitDatabaseTransaction();
        }
        catch (Exception ex) {
            log.error("Error refreshing illness records", ex);
            DatabaseTransactionHelper.rollbackDatabaseTransaction();
        }
        finally {
            long endTime = System.currentTimeMillis();
            log.debug("Illness refresh complete in {}ms", (Object)(endTime - startTime));
            this.illnessCheckLock.unlock();
            this.processManualQueue();
        }
    }

    private void progressExistingIllnesses(EQHorse horse) {
        List<IllnessHorse> currentIllnesses = this.illnessHorseRepository.findUncuredRecordsForHorse(horse.getId());
        currentIllnesses.forEach(ci -> this.progressIllness(horse, (IllnessHorse)ci));
    }

    private void progressIllness(EQHorse horse, IllnessHorse illnessHorse) {
        Illness currentIllness = illnessHorse.getIllness();
        List<IllnessEffect> currentEffects = currentIllness.getIllnessEffects();
        long millisIntoIllness = illnessHorse.getEffectiveDurationHad().toMillis();
        List<IllnessEffect> activeEffects = currentIllness.getIllnessEffects().stream().filter(e -> this.isEffectWithinActiveTime((IllnessEffect)e, millisIntoIllness)).filter(e -> this.checkPreCondition((IllnessEffect)e, horse)).toList();
        List<IllnessEffect> endedEffects = currentEffects.stream().filter(Predicate.not(activeEffects::contains)).toList();
        this.advanceIllness(horse, currentIllness, activeEffects, endedEffects, illnessHorse);
    }

    private boolean isEffectWithinActiveTime(IllnessEffect effect, long millisIntoIllness) {
        long startDurationMillis = (long)effect.getStartDurationHours() * 3600000L;
        if (startDurationMillis > millisIntoIllness) {
            return false;
        }
        if (effect.getEndDurationHours() == null) {
            return true;
        }
        long endDurationMillis = (long)effect.getEndDurationHours().intValue() * 3600000L;
        return endDurationMillis > millisIntoIllness;
    }

    private boolean checkPreCondition(IllnessEffect illnessEffect, EQHorse horse) {
        if (illnessEffect.getPreConditionScript().isBlank()) {
            return true;
        }
        APIHorseDtoImpl horseDto = new APIHorseDtoImpl(horse);
        try {
            GroovyScriptResponse<RuleScriptResponse> result = ((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)GroovyRuleScriptExecutor.start(illnessEffect.getPreConditionScript()).withHorse(horseDto)).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).execute();
            return result.result().success();
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing pre-condition script for effect %s", illnessEffect.getName()), ex);
            return false;
        }
    }

    private void advanceIllness(EQHorse horse, Illness currentIllness, List<IllnessEffect> activeEffects, List<IllnessEffect> endedEffects, IllnessHorse currentIllnessHorse) {
        ScriptExecutionResponse scriptExecutionResponse = this.executeEndedScripts(horse, endedEffects);
        if (scriptExecutionResponse.shouldKill || this.testForKill(endedEffects)) {
            try {
                horse.getDeath().kill(currentIllness.getName());
            }
            catch (HorseDeadException horseDeadException) {
                // empty catch block
            }
        }
        if (scriptExecutionResponse.shouldCure || this.testForCure(endedEffects)) {
            this.illnessHorseUpdateSession.cureIllness(currentIllnessHorse);
        }
        List<Integer> illnessIdsToGive = scriptExecutionResponse.illnessesToTrigger.stream().map(Illness::getId).toList();
        this.giveIllnessesToHorse(horse, illnessIdsToGive);
        List<UUID> activeEffectIds = activeEffects.stream().map(IllnessEffect::getId).toList();
        currentIllnessHorse.setActiveEffectIds(activeEffectIds);
        currentIllnessHorse.save();
    }

    private boolean testForKill(List<IllnessEffect> effects) {
        return effects.stream().anyMatch(e -> ProbabilityUtils.testPercentageProbability(e.getKillPercentageProbability()));
    }

    private boolean testForCure(List<IllnessEffect> effects) {
        return effects.stream().anyMatch(e -> ProbabilityUtils.testPercentageProbability(e.getCurePercentageProbability()));
    }

    private ScriptExecutionResponse executeEndedScripts(EQHorse horse, List<IllnessEffect> effects) {
        APIHorseDto apiHorseDto = this.horseTransformer.toApiDto(horse);
        return effects.stream().map(e -> this.executeEndedScript(apiHorseDto, (IllnessEffect)e)).collect(Collector.of(ScriptExecutionResponse::new, ScriptExecutionResponse::apply, ScriptExecutionResponse::merge, new Collector.Characteristics[0]));
    }

    private ScriptExecutionResponse executeEndedScript(APIHorseDto horse, IllnessEffect effect) {
        if (effect.getOnEndScript().isBlank()) {
            return ScriptExecutionResponse.none;
        }
        try {
            IllnessEffectEndAction actionFunction = new IllnessEffectEndAction();
            ((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(effect.getOnEndScript()).withHorse(horse)).withVariable("action", actionFunction)).execute();
            List<Illness> illnesses = actionFunction.getIllnessesToTrigger().stream().map(identifier -> this.illnessRepository.findByIdentifier((String)identifier)).filter(Optional::isPresent).map(Optional::get).toList();
            return new ScriptExecutionResponse(ProbabilityUtils.testPercentageProbability(actionFunction.getKillHorseProbabilityPercentage()), ProbabilityUtils.testPercentageProbability(actionFunction.getCureHorseProbabilityPercentage()), illnesses);
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing on end script for effect %s", effect.getName()), ex);
            return ScriptExecutionResponse.none;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processManualQueue() {
        this.illnessCheckLock.sharedLock();
        try {
            log.debug("Processing any manually queued illnesses");
            Map<EQHorse, List<Integer>> map = this.manualIllnessQueue.getAndClear();
            for (Map.Entry<EQHorse, List<Integer>> entry : map.entrySet()) {
                EQHorse horse = entry.getKey();
                List<Integer> illnessIds = entry.getValue();
                this.giveIllnessesToHorse(horse, illnessIds);
            }
        }
        finally {
            log.debug("Manual illness queue processed");
            this.illnessCheckLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void giveIllnessesToHorse(EQHorse horse, List<Integer> illnessIds) {
        if (FeatureFlag.ILLNESSES.isDisabled()) {
            return;
        }
        if (illnessIds.isEmpty()) {
            return;
        }
        if (this.illnessCheckLock.conditionalLock()) {
            try {
                log.debug("Giving illnesses to horse");
                DatabaseTransactionHelper.startDatabaseTransaction();
                illnessIds.forEach(illnessId -> this.giveIllnessToHorse(horse, (int)illnessId));
                DatabaseTransactionHelper.commitDatabaseTransaction();
            }
            catch (Exception ex) {
                log.error("Error giving illnesses to a horse", ex);
                DatabaseTransactionHelper.rollbackDatabaseTransaction();
            }
            finally {
                this.illnessCheckLock.unlock();
            }
        } else {
            log.debug("Added manually added illnesses to queue");
            this.manualIllnessQueue.add(horse, illnessIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void giveIllnessToHorse(EQHorse horse, int illnessId) {
        if (FeatureFlag.ILLNESSES.isDisabled()) {
            return;
        }
        if (this.illnessCheckLock.conditionalLock()) {
            try {
                log.debug("Giving illnesses to horse");
                if (horse.getIllness().hasIllness(illnessId)) return;
                Illness illness = (Illness)this.illnessRepository.findByKey(illnessId);
                IllnessHorse illnessRecord = this.createNewIllnessHorseRecord(illness, horse, System.currentTimeMillis());
                this.illnessHorseRepository.add(illnessRecord);
                this.executeOnApplyScript(illness, horse);
                return;
            }
            finally {
                this.illnessCheckLock.unlock();
            }
        } else {
            log.debug("Added manually added illness to queue");
            this.manualIllnessQueue.add(horse, illnessId);
        }
    }

    private IllnessHorse createNewIllnessHorseRecord(Illness illness, EQHorse horse, long time) {
        float speedFactor = this.determineStartingSpeedFactor(illness);
        return new IllnessHorse(0, illness.getId(), horse.getId(), time, 0, speedFactor, null, 0, null, null, new ArrayList<UUID>(0));
    }

    private float determineStartingSpeedFactor(Illness illness) {
        float speedFactor;
        if (illness.getInitialSpeedPercentageTolerance() <= 0) {
            speedFactor = 1.0f;
        } else {
            int percentage = NumberUtils.randomIntInRange(-illness.getInitialSpeedPercentageTolerance(), illness.getInitialSpeedPercentageTolerance());
            speedFactor = (float)PercentageUtils.of(1.0, percentage);
        }
        return speedFactor;
    }

    private void executeOnApplyScript(Illness illness, EQHorse horse) {
        if (illness.getOnApplyScript().isBlank()) {
            return;
        }
        APIHorseDto h = this.horseTransformer.toApiDto(horse);
        APIHorseIllnessDto illnessRecord = (APIHorseIllnessDto)h.getIllnesses().getUncured().get(illness.getId());
        try {
            ((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(illness.getOnApplyScript()).withHorse(h)).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).withVariable("illness", illnessRecord)).execute();
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing on apply script for illness %s", illness.getName()), ex);
        }
    }

    private static class ScriptExecutionResponse {
        private boolean shouldKill = false;
        private boolean shouldCure = false;
        private List<Illness> illnessesToTrigger = new ArrayList<Illness>(0);
        static ScriptExecutionResponse none = new ScriptExecutionResponse();

        ScriptExecutionResponse() {
        }

        ScriptExecutionResponse(boolean shouldKill, boolean shouldCure, List<Illness> illnessToTrigger) {
            this.shouldKill = shouldKill;
            this.shouldCure = shouldCure;
            this.illnessesToTrigger = illnessToTrigger;
        }

        void apply(ScriptExecutionResponse other) {
            if (other.shouldKill) {
                this.shouldKill = true;
            }
            if (other.shouldCure) {
                this.shouldCure = true;
            }
            this.illnessesToTrigger.addAll(other.illnessesToTrigger);
        }

        ScriptExecutionResponse merge(ScriptExecutionResponse other) {
            return new ScriptExecutionResponse(this.shouldKill || other.shouldKill, this.shouldCure || other.shouldCure, ListUtils.concatDistinct(this.illnessesToTrigger, other.illnessesToTrigger));
        }
    }
}

