/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.horse.illness.IllnessHorseDatabase;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class IllnessHorseRepository
extends Repository<IllnessHorse, Integer> {
    @Service
    private IllnessHorseDatabase illnessHorseDatabase;

    @Override
    protected RepositoryDatasource<IllnessHorse, Integer> getDatasource() {
        return this.illnessHorseDatabase;
    }

    @Override
    protected Function<IllnessHorse, Object> getIndexFunction() {
        return IllnessHorse::getHorseId;
    }

    public Optional<IllnessHorse> findMostRecentRecordForHorseAndIllness(int horseId, int illnessId) {
        RepositorySearchQuery<IllnessHorse> searchQuery = this.createSearchQuery();
        searchQuery.filter(im -> im.getHorseId() == horseId);
        searchQuery.filter(im -> im.getIllnessId() == illnessId);
        long now = System.currentTimeMillis();
        searchQuery.sortReverse((m1, m2) -> {
            long cureTimeM1 = m1.isCured() ? m1.getCureTime() : now;
            long cureTimeM2 = m2.isCured() ? m2.getCureTime() : now;
            return Long.compare(cureTimeM1, cureTimeM2);
        });
        return searchQuery.single();
    }

    public List<IllnessHorse> findUncuredRecordsForHorse(int horseId) {
        return this.findListByPredicates(ih -> ih.getHorseId() == horseId, IllnessHorse::isUncured);
    }

    public List<IllnessHorse> findByHorse(int horseId) {
        return this.findListByIndexKey(horseId);
    }
}

