/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ProbabilityUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.horse.illness.IllnessHorseRepository;
import com.equestricraft.core.horse.illness.IllnessHorseSession;
import com.equestricraft.core.horse.illness.check.IllnessHorseCheckSession;
import com.equestricraft.core.horse.proximity.HorseProximityService;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessEffect;
import com.equestricraft.core.illness.IllnessRepository;
import com.equestricraft.core.illness.IllnessSettings;
import com.equestricraft.core.illness.condition.IllnessCondition;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public class IllnessHorseSessionImpl
implements IllnessHorseSession {
    @Service
    private IllnessRepository illnessRepository;
    @Service
    private IllnessHorseRepository illnessHorseRepository;
    @Service
    private IllnessHorseCheckSession illnessHorseCheckSession;
    @Service
    private HorseProximityService horseProximityService;

    @Override
    public List<Illness> retrieveIllnessesHorseCanGet(EQHorse horse) {
        List<Illness> allIllnesses = this.illnessRepository.findAllActiveIllnesses();
        return allIllnesses.stream().filter(i -> this.shouldHorseGetIllness(horse, (Illness)i)).toList();
    }

    private boolean shouldHorseGetIllness(EQHorse horse, Illness illness) {
        Optional<IllnessHorse> illnessHorse = this.illnessHorseRepository.findMostRecentRecordForHorseAndIllness(horse.getId(), illness.getId());
        Duration durationSinceCured = null;
        if (illnessHorse.isPresent()) {
            IllnessHorse ih = illnessHorse.get();
            if (ih.isUncured()) {
                return false;
            }
            durationSinceCured = DateUtils.durationSince(ih.getCureTime());
        }
        if (this.hasBeenTestedTooRecently(horse, illness, durationSinceCured)) {
            return false;
        }
        if (this.canGetByContagious(horse, illness)) {
            return true;
        }
        return this.doesProbabilityTestPass(horse, illness);
    }

    private boolean hasBeenTestedTooRecently(EQHorse horse, Illness illness, Duration durationSinceCured) {
        Optional<Duration> sinceLastCheck = this.illnessHorseCheckSession.getDurationSinceLastCheck(illness.getId(), horse.getId());
        if (sinceLastCheck.isPresent()) {
            Duration durationSinceLastChecked = sinceLastCheck.get();
            if (durationSinceCured != null && durationSinceLastChecked.toMillis() < durationSinceCured.toMillis()) {
                return false;
            }
            int globalHoursToWait = IllnessSettings.getProbabilityWaitIntervalHours();
            return (long)globalHoursToWait > durationSinceLastChecked.toHours();
        }
        return false;
    }

    private boolean canGetByContagious(EQHorse horse, Illness illness) {
        if (illness.getContagiousRange() == 0) {
            return false;
        }
        List<EQHorse> horsesInRange = this.horseProximityService.getAliveHorsesInRange(horse, illness.getContagiousRange());
        return horsesInRange.stream().anyMatch(h -> this.canHorseSpreadIllness((EQHorse)h, illness));
    }

    private boolean canHorseSpreadIllness(EQHorse horse, Illness illness) {
        Optional<IllnessHorse> illnessHorse = horse.getIllness().getCurrentRecordForIllness(illness.getId());
        if (illnessHorse.isPresent()) {
            List<IllnessEffect> effects = illnessHorse.get().getActiveEffects();
            return effects.stream().anyMatch(IllnessEffect::isContagious);
        }
        return false;
    }

    private boolean doesProbabilityTestPass(EQHorse horse, Illness illness) {
        double baseProbability = illness.getBaseProbability();
        ConditionCheckResult conditionCheckResult = this.executeConditions(horse, illness);
        if (conditionCheckResult.hasMandatoryConditionFailure()) {
            return false;
        }
        double totalProbability = baseProbability + conditionCheckResult.probabilityIncrease();
        this.illnessHorseCheckSession.setLastIllnessCheckForHorse(illness.getId(), horse.getId());
        float immunity = horse.getIllness().getImmunity(illness.getId()).getPercentage();
        if (immunity > 0.0f) {
            totalProbability *= (double)(1.0f - immunity);
        }
        return ProbabilityUtils.testPercentageProbability(totalProbability);
    }

    private ConditionCheckResult executeConditions(EQHorse horse, Illness illness) {
        double totalProbabilityIncrease = 0.0;
        for (IllnessCondition condition : illness.getIllnessConditionList()) {
            boolean passed = condition.getExecutor().execute(horse);
            if (passed) {
                totalProbabilityIncrease += condition.getProbabilityIncrease();
                continue;
            }
            if (!condition.isMandatory()) continue;
            return ConditionCheckResult.failure();
        }
        return ConditionCheckResult.success(totalProbabilityIncrease);
    }

    record ConditionCheckResult(boolean hasMandatoryConditionFailure, double probabilityIncrease) {
        static ConditionCheckResult success(double probabilityIncrease) {
            return new ConditionCheckResult(false, probabilityIncrease);
        }

        static ConditionCheckResult failure() {
            return new ConditionCheckResult(true, 0.0);
        }
    }
}

