/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.api.common.APIHorseDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.horse.illness.IllnessHorseUpdateSession;
import com.equestricraft.core.horse.illness.immunity.HorseImmunitySession;
import com.equestricraft.core.illness.APIIllnessDtoImpl;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;

public class IllnessHorseUpdateSessionImpl
implements IllnessHorseUpdateSession {
    @Service
    private HorseImmunitySession horseImmunitySession;
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorseTransformer horseTransformer;
    private static final Log log = Log.getLogger(IllnessHorseUpdateSessionImpl.class.getName());

    @Override
    public boolean cureIllness(IllnessHorse illnessHorse) {
        if (illnessHorse.isCured()) {
            return false;
        }
        Illness illness = illnessHorse.getIllness();
        this.executeCureScript(illnessHorse, illness);
        long time = System.currentTimeMillis();
        illnessHorse.setCureTime(time);
        illnessHorse.save();
        this.horseImmunitySession.increaseImmunityAgainstIllness(illness, illnessHorse.getHorseId(), illness.getCureImmunityBoostPercentage());
        return true;
    }

    private void executeCureScript(IllnessHorse illnessHorse, Illness illness) {
        if (illness.getOnCureScript().isBlank()) {
            return;
        }
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(illnessHorse.getHorseId());
        APIHorseDto horseDto = this.horseTransformer.toApiDto(horse);
        APIIllnessDtoImpl illnessDto = new APIIllnessDtoImpl(illness);
        try {
            ((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(illness.getOnCureScript()).withHorse(horseDto)).withVariable("illness", illnessDto)).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).execute();
        }
        catch (GroovyException ex) {
            log.error("Error executing cure script for illness " + illness.getName() + " on horse " + horse.getName(), ex);
        }
    }
}

