/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.base.eventbus.ECEventBusListener;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.illness.IllnessHorseEngine;
import com.equestricraft.core.illness.IllnessSettings;
import com.equestricraft.core.repeatingtask.RepeatingTask;
import com.equestricraft.core.repeatingtask.RepeatingTaskManager;
import com.equestricraft.core.setting.ECPostSettingsLoadEvent;
import java.time.Duration;

public class IllnessUpdateTask
extends RepeatingTask {
    @Service
    private IllnessHorseEngine illnessHorseEngine;
    private static final String TASK_NAME = "Illness Checker";

    @Override
    public String name() {
        return TASK_NAME;
    }

    @Override
    public void execute() {
        this.illnessHorseEngine.performIllnessChecks();
    }

    @Override
    public Duration delay() {
        return Duration.ofMinutes(IllnessSettings.getCheckIntervalMinutes().intValue());
    }

    @Override
    public Duration period() {
        return Duration.ofMinutes(IllnessSettings.getCheckIntervalMinutes().intValue());
    }

    @ECEventBusListener
    public static void onSettingsLoad(ECPostSettingsLoadEvent event) {
        if (event.getKeys().contains("illness.check-interval-minutes")) {
            RepeatingTaskManager.getInstance().restartTask(TASK_NAME);
        }
    }
}

