/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness;

import com.equestricraft.common.util.MapUtils;
import com.equestricraft.core.horse.EQHorse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManualIllnessQueue {
    private static final ManualIllnessQueue instance = new ManualIllnessQueue();
    private final Map<EQHorse, List<Integer>> horseIllnessMap = new HashMap<EQHorse, List<Integer>>();

    public static ManualIllnessQueue getInstance() {
        return instance;
    }

    private ManualIllnessQueue() {
    }

    public synchronized void add(EQHorse horse, Integer illnessId) {
        MapUtils.safeListAdd(this.horseIllnessMap, horse, illnessId);
    }

    public synchronized void add(EQHorse horse, List<Integer> illnessIds) {
        MapUtils.safeListAdd(this.horseIllnessMap, horse, illnessIds);
    }

    public synchronized Map<EQHorse, List<Integer>> getAndClear() {
        HashMap<EQHorse, List<Integer>> clone = new HashMap<EQHorse, List<Integer>>(this.horseIllnessMap);
        this.horseIllnessMap.clear();
        return clone;
    }
}

