/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness.check;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.illness.check.IllnessHorseCheckKey;
import com.equestricraft.core.horse.illness.check.IllnessHorseCheckRepository;
import java.util.Objects;

public class IllnessHorseCheck
implements RepositoryEntity<IllnessHorseCheckKey> {
    private final IllnessHorseCheckKey key;
    private long timeStamp;

    public IllnessHorseCheck(int illnessId, int horseId, long timeStamp) {
        this.key = new IllnessHorseCheckKey(illnessId, horseId);
        this.timeStamp = timeStamp;
    }

    @Override
    public IllnessHorseCheckKey getKey() {
        return this.key;
    }

    public int getIllnessId() {
        return this.getKey().illnessId();
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public void save() {
        Services.getService(IllnessHorseCheckRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IllnessHorseCheck that = (IllnessHorseCheck)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

