/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness.check;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.illness.check.IllnessHorseCheck;
import com.equestricraft.core.horse.illness.check.IllnessHorseCheckKey;
import java.util.List;

public class IllnessHorseCheckDatabase
implements RepositoryDatasource<IllnessHorseCheck, IllnessHorseCheckKey> {
    private static final String COLUMN_ILLNESS_ID = "ILLNESS_ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";

    @Override
    public void create(IllnessHorseCheck illnessHorseCheck) {
        Query.insertInto("ILLNESS_HORSE_CHECK").columns(QueryColumn.column(COLUMN_ILLNESS_ID, illnessHorseCheck.getIllnessId()), QueryColumn.column(COLUMN_HORSE_ID, illnessHorseCheck.getHorseId()), QueryColumn.column(COLUMN_TIME_STAMP, illnessHorseCheck.getTimeStamp())).execute();
    }

    @Override
    public List<IllnessHorseCheck> retrieveAll() {
        return Query.selectAllFrom("ILLNESS_HORSE_CHECK").getList(this::getIllnessHorseCheckFromResultRow);
    }

    private IllnessHorseCheck getIllnessHorseCheckFromResultRow(ResultRow row) {
        int illnessId = row.getInt(COLUMN_ILLNESS_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        return new IllnessHorseCheck(illnessId, horseId, timeStamp);
    }

    @Override
    public void update(IllnessHorseCheck illnessHorseCheck) {
        Query.update("ILLNESS_HORSE_CHECK").set(QueryColumn.column(COLUMN_TIME_STAMP, illnessHorseCheck.getTimeStamp())).where(QueryColumn.column(COLUMN_ILLNESS_ID, illnessHorseCheck.getIllnessId()), QueryColumn.column(COLUMN_HORSE_ID, illnessHorseCheck.getHorseId())).execute();
    }
}

