/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness.check;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.illness.check.IllnessHorseCheck;
import com.equestricraft.core.horse.illness.check.IllnessHorseCheckRepository;
import com.equestricraft.core.horse.illness.check.IllnessHorseCheckSession;
import java.time.Duration;
import java.util.Optional;

public class IllnessHorseCheckSessionImpl
implements IllnessHorseCheckSession {
    @Service
    private IllnessHorseCheckRepository illnessHorseCheckRepository;

    @Override
    public void setLastIllnessCheckForHorse(int illnessId, int horseId) {
        long timeStamp = System.currentTimeMillis();
        Optional<IllnessHorseCheck> existingCheck = this.illnessHorseCheckRepository.findCheckByIllnessAndHorse(illnessId, horseId);
        if (existingCheck.isPresent()) {
            existingCheck.get().setTimeStamp(timeStamp);
            existingCheck.get().save();
        } else {
            IllnessHorseCheck newCheck = new IllnessHorseCheck(illnessId, horseId, timeStamp);
            this.illnessHorseCheckRepository.add(newCheck);
        }
    }

    @Override
    public Optional<Duration> getDurationSinceLastCheck(int illnessId, int horseId) {
        return this.illnessHorseCheckRepository.findCheckByIllnessAndHorse(illnessId, horseId).map(IllnessHorseCheck::getTimeStamp).map(Duration::ofMillis);
    }
}

