/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness.immunity;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.illness.immunity.HorseImmunitySession;
import com.equestricraft.core.horse.illness.immunity.IllnessImmunityHorse;
import com.equestricraft.core.horse.illness.immunity.IllnessImmunityHorseRepository;
import com.equestricraft.core.horse.medicine.HorseMedicineSession;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessMedicine;
import com.equestricraft.core.illness.IllnessRepository;
import java.util.Optional;

public class HorseImmunitySessionImpl
implements HorseImmunitySession {
    @Service
    private IllnessRepository illnessRepository;
    @Service
    private IllnessImmunityHorseRepository illnessImmunityHorseRepository;
    @Service
    private HorseMedicineSession horseMedicineSession;

    @Override
    public float calculateImmunityForHorseAgainstIllness(EQHorse horse, Illness illness) {
        Float immunity = this.illnessImmunityHorseRepository.findByIllnessAndHorse(illness.getId(), horse.getId()).map(this::getPercentageForHorseImmunity).orElse(Float.valueOf(0.0f));
        float medicineImmunity = this.getMedicineImmunity(horse, illness);
        float totalImmunity = immunity.floatValue() + medicineImmunity;
        return NumberUtils.keepWithinRange(Float.valueOf(totalImmunity), Float.valueOf(0.0f), Float.valueOf(1.0f)).floatValue();
    }

    private float getPercentageForHorseImmunity(IllnessImmunityHorse h) {
        Illness illness = (Illness)this.illnessRepository.findByKey(h.getIllnessId());
        if (illness.getImmunityScaleTimeHours() == 0) {
            return 0.0f;
        }
        long millisUntilExpiry = DateUtils.millisUntil(h.getExpiryTime());
        long totalMillis = (long)illness.getImmunityScaleTimeHours() * 3600000L;
        float percentage = (float)millisUntilExpiry / (float)totalMillis;
        return NumberUtils.keepWithinRange(Float.valueOf(percentage), Float.valueOf(0.0f), Float.valueOf(1.0f)).floatValue();
    }

    private float getMedicineImmunity(EQHorse horse, Illness illness) {
        return (float)illness.getMedicines().stream().filter(IllnessMedicine::affectsImmunity).mapToDouble(im -> {
            float effectiveness = this.horseMedicineSession.getHorsesEffectivenessForMedicine(horse.getId(), im.getMedicine());
            return (float)im.getImmunityPercentageGain() * effectiveness;
        }).map(v -> v / 100.0).average().orElse(0.0);
    }

    @Override
    public void increaseImmunityAgainstIllness(Illness illness, int horseId, int percentage) {
        if (percentage <= 0) {
            return;
        }
        Optional<IllnessImmunityHorse> existing = this.illnessImmunityHorseRepository.findByIllnessAndHorse(illness.getId(), horseId);
        long totalMillis = (long)illness.getImmunityScaleTimeHours() * 3600000L;
        long millisToAdd = PercentageUtils.of(totalMillis, percentage);
        if (existing.isPresent()) {
            long newTime = existing.get().getExpiryTime() + millisToAdd;
            existing.get().setExpiryTime(newTime);
            existing.get().save();
        } else {
            long time = System.currentTimeMillis() + millisToAdd;
            IllnessImmunityHorse newRecord = new IllnessImmunityHorse(illness.getId(), horseId, time);
            this.illnessImmunityHorseRepository.add(newRecord);
        }
    }
}

