/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness.immunity;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.illness.immunity.IllnessImmunityHorseKey;
import com.equestricraft.core.horse.illness.immunity.IllnessImmunityHorseRepository;
import java.util.Objects;

public class IllnessImmunityHorse
implements RepositoryEntity<IllnessImmunityHorseKey> {
    private final IllnessImmunityHorseKey key;
    private long expiryTime;

    public IllnessImmunityHorse(int illnessId, int horseId, long expiryTime) {
        this.key = new IllnessImmunityHorseKey(illnessId, horseId);
        this.expiryTime = expiryTime;
    }

    @Override
    public IllnessImmunityHorseKey getKey() {
        return this.key;
    }

    public int getIllnessId() {
        return this.getKey().illnessId();
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    @Override
    public void save() {
        Services.getService(IllnessImmunityHorseRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IllnessImmunityHorse that = (IllnessImmunityHorse)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

