/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.illness.immunity;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.illness.immunity.IllnessImmunityHorse;
import com.equestricraft.core.horse.illness.immunity.IllnessImmunityHorseKey;
import java.util.List;

public class IllnessImmunityHorseDatabase
implements RepositoryDatasource<IllnessImmunityHorse, IllnessImmunityHorseKey> {
    private static final String COLUMN_ILLNESS_ID = "ILLNESS_ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_EXPIRY_TIME = "EXPIRY_TIME";

    @Override
    public void create(IllnessImmunityHorse illnessImmunityHorse) {
        Query.insertInto("ILLNESS_IMMUNITY_HORSE").columns(QueryColumn.column(COLUMN_ILLNESS_ID, illnessImmunityHorse.getIllnessId()), QueryColumn.column(COLUMN_HORSE_ID, illnessImmunityHorse.getHorseId()), QueryColumn.column(COLUMN_EXPIRY_TIME, illnessImmunityHorse.getExpiryTime())).execute();
    }

    @Override
    public List<IllnessImmunityHorse> retrieveAll() {
        return Query.selectAllFrom("ILLNESS_IMMUNITY_HORSE").getList(this::getFromResultRow);
    }

    private IllnessImmunityHorse getFromResultRow(ResultRow row) {
        int illnessId = row.getInt(COLUMN_ILLNESS_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        long expiryTime = row.getLong(COLUMN_EXPIRY_TIME);
        return new IllnessImmunityHorse(illnessId, horseId, expiryTime);
    }

    @Override
    public void update(IllnessImmunityHorse illnessImmunityHorse) {
        Query.update("ILLNESS_IMMUNITY_HORSE").set(QueryColumn.column(COLUMN_EXPIRY_TIME, illnessImmunityHorse.getExpiryTime())).where(QueryColumn.column(COLUMN_ILLNESS_ID, illnessImmunityHorse.getIllnessId()), QueryColumn.column(COLUMN_HORSE_ID, illnessImmunityHorse.getHorseId())).execute();
    }
}

