/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.information;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.DateFormatter;
import com.equestricraft.common.NumberFormatter;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.aggression.AggressionTrait;
import com.equestricraft.core.horse.appetite.HighAppetiteTrait;
import com.equestricraft.core.horse.bit.BitInformation;
import com.equestricraft.core.horse.breed.HorseBreedAccessor;
import com.equestricraft.core.horse.gait.Canter;
import com.equestricraft.core.horse.gait.Gallop;
import com.equestricraft.core.horse.gait.Trot;
import com.equestricraft.core.horse.gait.Walk;
import com.equestricraft.core.horse.information.HorseBasicViewDetails;
import com.equestricraft.core.horse.information.HorseBreedCertificateInformation;
import com.equestricraft.core.horse.information.HorseCertificatesInfo;
import com.equestricraft.core.horse.information.HorseDetailsInformation;
import com.equestricraft.core.horse.information.HorseIndividualBreedViewItem;
import com.equestricraft.core.horse.information.HorseIndividualParentViewItem;
import com.equestricraft.core.horse.information.HorseInformationViewSession;
import com.equestricraft.core.horse.information.HorseParentalViewInformation;
import com.equestricraft.core.horse.information.HorseStatsInformation;
import com.equestricraft.core.horse.information.HorseVitaminInformation;
import com.equestricraft.core.horse.information.HorseWelfareInformation;
import com.equestricraft.core.horse.medicine.HorseMedicineInformation;
import com.equestricraft.core.horse.nutrient.HorseNutrientInfo;
import com.equestricraft.core.horse.obedience.ObedienceTrait;
import com.equestricraft.core.horse.permission.HorsePermissionChecker;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.horse.restless.RestlessTrait;
import com.equestricraft.core.horse.shoe.ShoeInformation;
import com.equestricraft.core.horse.spook.SpookTrait;
import com.equestricraft.core.horse.stats.HorseStat;
import com.equestricraft.core.horse.trust.HorsePlayerTrustInfo;
import com.equestricraft.core.horse.weight.HorseWeightInfo;
import com.equestricraft.core.nutrient.Nutrient;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.featureflag.FeatureFlag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class HorseInformationViewSessionImpl
implements HorseInformationViewSession {
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public HorseBasicViewDetails retrieveBasicInformationForHorse(ECPlayer viewingPlayer, EQHorse horse) {
        String name = horse.getName();
        String showName = horse.getShowName();
        String owner = horse.getOwnerId() == viewingPlayer.getId() ? null : horse.getOwner().getIgn();
        HorseBreedAccessor breed = horse.getBreed();
        boolean showDisciplines = FeatureFlag.DISCIPLINE_CERTIFICATION.isDisabled() || horse.getLastDisciplineCertification() != null;
        Optional<Date> lastRideTime = horse.getRideTime().getLastRideTime();
        boolean pregnancyConfirmed = horse.getPregnancyAwareTime() != null;
        return new HorseBasicViewDetails(name, showName, owner, horse.getHorseGender().getTranslatedName(), horse.getAge().getDisplayString(), breed.getDisplayString(), horse.getHealth().getStatus(), horse.hasParents(), showDisciplines, lastRideTime.map(DateFormatter::formatDateDateMonthYear).orElse(null), pregnancyConfirmed, horse.getStallRest().isActive(), horse.getStatus().getCurrent());
    }

    @Override
    public HorseDetailsInformation retrieveHorseDetails(ECPlayer viewingPlayer, EQHorse horse) {
        String name = horse.getName();
        PlayerSimple owner = horse.getOwnerId() == viewingPlayer.getId() ? null : this.playerTransformer.toSimple(horse.getOwner().getCorePlayer());
        String showName = horse.getShowName();
        boolean hasParents = horse.hasParents();
        boolean immortal = horse.isImmortal();
        Optional<HorseWeightInfo> weightInfo = horse.getWeight().getInformation();
        HorsePlayerTrustInfo trust = horse.getTrust().getLevelInfo(viewingPlayer);
        HorseBreedAccessor breed = horse.getBreed();
        String sellPrice = EconomyUtilities.formatCurrency(horse.getCurrentValue());
        HorsePermissionLevel accessLevel = HorsePermissionChecker.getPlayersPermissionLevel(viewingPlayer, horse);
        Optional<ShoeInformation> shoeInformation = horse.getShoes().getInformationAboutShoe();
        Optional<BitInformation> bitInformation = horse.getBits().getBitInformation();
        double height = horse.getHeight().getHands();
        return new HorseDetailsInformation(name, owner, showName, horse.getHorseGender().getTranslatedName(), horse.getAge().getDisplayString(), hasParents, immortal, weightInfo.orElse(null), trust.config().getName(), breed.getDisplayString(), horse.isBreedClassified(), sellPrice, accessLevel, horse.getMicrochip().isMicrochipped(), shoeInformation.orElse(null), bitInformation.orElse(null), height, horse.getCoat().getDescription());
    }

    @Override
    public HorseParentalViewInformation retrieveParentalInformation(EQHorse horse) {
        if (!horse.hasParents()) {
            return null;
        }
        HorseIndividualParentViewItem motherInfo = this.buildInfo(horse.getMother().getEqHorse());
        HorseIndividualParentViewItem fatherInfo = this.buildInfo(horse.getFather().getEqHorse());
        return new HorseParentalViewInformation(motherInfo, fatherInfo);
    }

    private HorseIndividualParentViewItem buildInfo(EQHorse horse) {
        return new HorseIndividualParentViewItem(this.playerTransformer.toSimple(horse.getOwner().getCorePlayer()), horse.getName(), horse.getShowName(), !horse.isDead());
    }

    @Override
    public HorseBreedCertificateInformation retrieveBreedInformation(EQHorse horse) {
        String displayName = horse.getBreed().getDisplayString();
        List<HorseIndividualBreedViewItem> breedsToShow = horse.getBreed().getBreeds().stream().map(b -> {
            Breed breed = b.getBreed();
            return new HorseIndividualBreedViewItem(breed.getId(), breed.getName(), NumberFormatter.format2DP(b.getPercentage()) + "%", breed.getDescription());
        }).toList();
        return new HorseBreedCertificateInformation(horse.getName(), displayName, breedsToShow);
    }

    @Override
    public HorseWelfareInformation retrieveWelfareInformation(ECPlayer viewingPlayer, EQHorse horse) {
        HorsePermissionLevel accessLevel = HorsePermissionChecker.getPlayersPermissionLevel(viewingPlayer, horse);
        Integer fullnessStatus = accessLevel.isAtLeast(HorsePermissionLevel.BASIC) ? Integer.valueOf((int)horse.getProvision().getFullnessPercentage()) : null;
        Integer hydrationStatus = accessLevel.isAtLeast(HorsePermissionLevel.BASIC) ? Integer.valueOf((int)horse.getProvision().getHydrationPercentage()) : null;
        boolean hasIllnessesToShow = horse.getIllness().hasUncuredAwareIllnesses();
        boolean hasVisibleSymptoms = horse.getSymptoms().hasVisibleSymptoms(viewingPlayer);
        boolean hasVisibleMedicines = accessLevel.isAtLeast(HorsePermissionLevel.BASIC) && !horse.getMedicine().getCurrentMedicineInformation().isEmpty();
        boolean canViewVitamins = accessLevel.isAtLeast(HorsePermissionLevel.BASIC);
        String bloodType = horse.isShowBloodTypeToPlayer() ? horse.getBlood().getType().getIdentifier() : null;
        int hoofLengthPercentage = horse.getHooves().getLengthPercentage();
        int hoofCleanPercentage = (int)horse.getCare().getHoofCleanliness() * 100;
        int cleanPercentage = (int)horse.getCare().getCleanliness() * 100;
        boolean dailyCareComplete = horse.getCare().isDailyCareDone();
        boolean showAsInHeat = FeatureFlag.MARE_HEAT.isEnabled() && horse.getBreeding().isInHeat();
        return new HorseWelfareInformation(fullnessStatus, hydrationStatus, horse.getHealth().getStatus(), hasIllnessesToShow, hasVisibleSymptoms, hasVisibleMedicines, canViewVitamins, bloodType, horse.getWormer().isWormed(), hoofLengthPercentage, hoofCleanPercentage, cleanPercentage, dailyCareComplete, showAsInHeat);
    }

    @Override
    public List<HorseMedicineInformation> retrieveMedicineInformation(ECPlayer viewingPlayer, EQHorse horse) {
        HorsePermissionLevel viewStatus = HorsePermissionChecker.getPlayersPermissionLevel(viewingPlayer, horse);
        return viewStatus.isAtLeast(HorsePermissionLevel.BASIC) ? horse.getMedicine().getCurrentMedicineInformation() : Collections.emptyList();
    }

    @Override
    public List<HorseVitaminInformation> retrieveHorseVitaminInformation(int viewingPlayerId, EQHorse horse) {
        ArrayList<Nutrient> vitamins = new ArrayList<Nutrient>(12);
        vitamins.add(Nutrient.VITAMIN_A);
        vitamins.add(Nutrient.VITAMIN_B1);
        vitamins.add(Nutrient.VITAMIN_B2);
        vitamins.add(Nutrient.VITAMIN_B3);
        vitamins.add(Nutrient.VITAMIN_B5);
        vitamins.add(Nutrient.VITAMIN_B7);
        vitamins.add(Nutrient.VITAMIN_B9);
        vitamins.add(Nutrient.VITAMIN_B12);
        vitamins.add(Nutrient.VITAMIN_C);
        vitamins.add(Nutrient.VITAMIN_D);
        vitamins.add(Nutrient.VITAMIN_E);
        vitamins.add(Nutrient.VITAMIN_K);
        return vitamins.stream().map(v -> horse.getNutrition().getInfoForNutrient((Nutrient)((Object)v))).map(this::buildVitaminInformation).toList();
    }

    private HorseVitaminInformation buildVitaminInformation(HorseNutrientInfo horseNutrientInfo) {
        return new HorseVitaminInformation(horseNutrientInfo.nutrient().getName(), horseNutrientInfo.value(), horseNutrientInfo.displayValue(), horseNutrientInfo.status());
    }

    @Override
    public HorseStatsInformation retrieveHorseStatsInformation(ECPlayer viewingPlayer, EQHorse horse) {
        HorseStat walkSpeed = horse.getSpeed().getStat(Walk.WORKING);
        HorseStat trotSpeed = horse.getSpeed().getStat(Trot.WORKING);
        HorseStat canterSpeed = horse.getSpeed().getStat(Canter.WORKING);
        HorseStat gallopSpeed = horse.getSpeed().getStat(Gallop.FULL);
        HorseStat jumpPower = horse.getJump().getStat();
        long currentMaximumStamina = horse.getStamina().getCurrentMaximum();
        long baseMaximumStamina = horse.getStamina().getCurrentMaximum();
        double intelligence = horse.getIntelligence().getPercentage();
        double memory = horse.getMemory().getPercentage();
        double aggression = (double)horse.getTraits().getValue(AggressionTrait.class) * 100.0;
        double appetite = (double)horse.getTraits().getValue(HighAppetiteTrait.class) * 100.0;
        double obedience = (double)horse.getTraits().getValue(ObedienceTrait.class) * 100.0;
        double restlessness = (double)horse.getTraits().getValue(RestlessTrait.class) * 100.0;
        double spookiness = (double)horse.getTraits().getValue(SpookTrait.class) * 100.0;
        double frustration = (double)horse.getFrustration().getValue() * 100.0;
        double stress = (double)horse.getStress().getValue() * 100.0;
        return new HorseStatsInformation(walkSpeed, trotSpeed, canterSpeed, gallopSpeed, jumpPower, currentMaximumStamina, baseMaximumStamina, intelligence, memory, aggression, appetite, obedience, restlessness, spookiness, frustration, stress);
    }

    @Override
    public HorseCertificatesInfo retrieveHorseCertificateInfo(ECPlayer viewingPlayer, EQHorse horse) {
        return new HorseCertificatesInfo(horse.isBreedClassified(), horse.getShowName() != null);
    }
}

