/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.instruction;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.instruction.HorseInstructionException;
import com.equestricraft.core.horse.instruction.HorseInstructionState;
import com.equestricraft.core.horse.instruction.HorseInstructionType;
import com.equestricraft.core.player.ECPlayer;

public abstract class HorseInstruction {
    protected final EQHorse horse;
    private ECPlayer player = null;

    protected HorseInstruction(EQHorse horse) {
        this.horse = horse;
    }

    public abstract String getInstructionLabel();

    public abstract HorseInstructionType getType();

    public final synchronized void start(ECPlayer player) throws HorseInstructionException {
        if (this.getState() == HorseInstructionState.ACTIVE) {
            throw new HorseInstructionException(I18n.getLabel("horse.instruction.already-active"));
        }
        this.player = null;
        Response canGive = this.canGive(player);
        if (!canGive.isSuccess()) {
            throw new HorseInstructionException(canGive.toString());
        }
        if (!this.shouldObey(player)) {
            throw new HorseInstructionException(I18n.getLabel("horse.instruction.did-not-obey"));
        }
        this.player = player;
        this.onStart(player);
    }

    public Response canGive(ECPlayer player) {
        return ResponseFactory.success();
    }

    private boolean shouldObey(ECPlayer player) {
        if (!this.horse.getObedience().shouldObey(player)) {
            return false;
        }
        return this.obeyCheck(player);
    }

    protected boolean obeyCheck(ECPlayer player) {
        return true;
    }

    protected abstract void onStart(ECPlayer var1);

    public final synchronized void stop() throws HorseInstructionException {
        if (this.getState() == HorseInstructionState.INACTIVE) {
            throw new HorseInstructionException(I18n.getLabel("horse.instruction.not-active"));
        }
        this.onStop(this.player);
    }

    protected void onStop(ECPlayer player) {
    }

    public ECPlayer getPlayer() {
        return this.player;
    }

    public abstract HorseInstructionState getState();
}

