/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.instruction;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.instruction.HorseInstruction;
import com.equestricraft.core.horse.instruction.HorseInstructionException;
import com.equestricraft.core.horse.instruction.HorseInstructionInfo;
import com.equestricraft.core.horse.instruction.HorseInstructionProvider;
import com.equestricraft.core.horse.instruction.HorseInstructionState;
import com.equestricraft.core.horse.instruction.HorseInstructionType;
import com.equestricraft.core.player.ECPlayer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HorseInstructionAccessor
extends AbstractHorseAccessor {
    @Service
    private static ServiceInstance<HorseInstructionProvider> horseInstructionProviders;
    private final Map<HorseInstructionType, HorseInstruction> instructions = this.buildInstructions();

    public HorseInstructionAccessor(EQHorse horse) {
        super(horse);
    }

    public void give(HorseInstructionType instructionType, ECPlayer player) throws HorseInstructionException {
        HorseInstruction instruction = this.instructions.get((Object)instructionType);
        instruction.start(player);
    }

    public void stop(HorseInstructionType type) throws HorseInstructionException {
        HorseInstruction instruction = this.instructions.get((Object)type);
        instruction.stop();
    }

    public List<HorseInstructionInfo> getAvailable(ECPlayer player) {
        return this.instructions.values().stream().filter(i -> i.canGive(player).isSuccess()).filter(i -> i.getState() == HorseInstructionState.INACTIVE || i.getPlayer() != null && i.getPlayer().equals(player)).map(i -> new HorseInstructionInfo(i.getInstructionLabel(), i.getType(), i.getState())).toList();
    }

    private Map<HorseInstructionType, HorseInstruction> buildInstructions() {
        return horseInstructionProviders.stream().collect(Collectors.toMap(HorseInstructionProvider::getType, p -> p.getInstruction(this.horse)));
    }
}

