/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.intelligence;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.trait.Trait;
import com.equestricraft.core.horse.trait.TraitVisitor;

public class IntelligenceTrait
implements Trait {
    @Override
    public String getName() {
        return I18n.getLabel("horse.trait.intelligence.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("horse.trait.intelligence.description");
    }

    @Override
    public <T> T accept(TraitVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public float getValue(EQHorse horse) {
        float value = horse.getBaseIntelligence().getValue().floatValue();
        double age = horse.getAge().getYears();
        if (age < 2.0) {
            return value * 0.7f;
        }
        if (age > 25.0) {
            return value * 0.8f;
        }
        return value;
    }
}

