/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.jobwork;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.jobwork.HorseJobWorkSession;
import com.equestricraft.core.horse.jobwork.JobWorkCheckInfo;
import com.equestricraft.core.horse.jobwork.JobWorkStatus;
import com.equestricraft.core.horse.jobwork.JobWorkStatusFunction;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobRepository;
import com.equestricraft.core.job.JobSimple;
import com.equestricraft.core.job.JobTransformer;
import com.equestricraft.core.job.JobWork;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class HorseJobWorkSessionImpl
implements HorseJobWorkSession {
    @Service
    private JobRepository jobRepository;
    @Service
    private JobTransformer jobTransformer;
    private static final Log log = Log.getLogger(HorseJobWorkSessionImpl.class.getName());

    @Override
    public List<JobSimple> retrieveJobsWorkWithWork(EQHorse horse) {
        return this.jobRepository.streamAll().filter(Predicate.not(j -> this.retrieveWorkNeededForJobOnHorse(horse, (Job)j).isEmpty())).map(this.jobTransformer::toSimple).toList();
    }

    @Override
    public List<JobWorkCheckInfo> retrieveWorkNeededForJobOnHorse(EQHorse horse, Job job) {
        return job.getWork().stream().map(w -> {
            JobWorkStatus r = this.executeWorkCheckScript(horse, (JobWork)w);
            if (r != null && r.getMessage() != null) {
                return new JobWorkCheckInfo(w.getId(), w.getName(), w.getDescription(), r.getMessage(), r.getColor(), r.isFlagged());
            }
            return null;
        }).filter(Objects::nonNull).sorted(Comparator.comparing(JobWorkCheckInfo::flagged).reversed()).toList();
    }

    private JobWorkStatus executeWorkCheckScript(EQHorse horse, JobWork work) {
        APIHorseDtoImpl dto = new APIHorseDtoImpl(horse);
        try {
            JobWorkStatusFunction statusFunction = new JobWorkStatusFunction();
            ((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(work.getCheckScript()).withHorse(dto)).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).withVariable("status", statusFunction)).execute();
            return statusFunction.getStatus();
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing script for job work %s", work.getName()), ex);
            return null;
        }
    }
}

