/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.lineage;

import com.equestricraft.api.common.APIHorseDto;
import com.equestricraft.api.common.APIHorseLineageDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.lineage.HorseLineageAccessor;

public class APIHorseLineageDtoImpl
implements APIHorseLineageDto {
    private final HorseLineageAccessor horseLineageAccessor;
    @Service
    private static HorseTransformer horseTransformer;

    public APIHorseLineageDtoImpl(HorseLineageAccessor horseLineageAccessor) {
        this.horseLineageAccessor = horseLineageAccessor;
    }

    @Override
    public float getCoefficientOfRelationship() {
        return this.horseLineageAccessor.getCoefficientOfRelationship();
    }

    @Override
    public float getCoefficientOfRelationshipWith(APIHorseDto horse) {
        EQHorse h = horseTransformer.fromDto(horse);
        return this.horseLineageAccessor.getCoefficientOfRelationshipWith(h);
    }

    @Override
    public int getLines() {
        return this.horseLineageAccessor.getLineageLines();
    }

    @Override
    public int getIncestCount() {
        return this.horseLineageAccessor.getIncestCount();
    }

    @Override
    public boolean isUnlocked() {
        return this.horseLineageAccessor.isUnlocked();
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.horseLineageAccessor.setUnlocked(unlocked);
    }

    public String toString() {
        return String.format("Incest Count: %s, Lineage Lines: %s, COR: %s", this.getIncestCount(), this.getLines(), Float.valueOf(this.getCoefficientOfRelationship()));
    }
}

