/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.lineage;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.lineage.LineageSession;

public class HorseLineageAccessor
extends AbstractHorseAccessor {
    @Service
    private static LineageSession lineageSession;
    private final CachedValue<Float> coefficientOfRelationship = new CachedValue<Float>(this::getUpdatedCoefficientOfRelationship);
    private final CachedValue<Integer> lineageLines = new CachedValue<Integer>(this::getUpdatedLineageLines);
    private final CachedValue<Integer> incestCount = new CachedValue<Integer>(this::getUpdatedIncestCount);

    public HorseLineageAccessor(EQHorse horse) {
        super(horse);
    }

    public float getCoefficientOfRelationship() {
        return this.coefficientOfRelationship.get().floatValue();
    }

    public float getCoefficientOfRelationshipWith(EQHorse otherHorse) {
        return lineageSession.calculateHorsesCoefficientOfRelationship(this.horse, otherHorse);
    }

    public int getLineageLines() {
        return this.lineageLines.get();
    }

    public int getIncestCount() {
        return this.incestCount.get();
    }

    public boolean isUnlocked() {
        return this.horse.isShowMoreLineageInformation();
    }

    public void setUnlocked(boolean unlocked) {
        this.horse.setShowMoreLineageInformation(unlocked);
        this.horse.save();
    }

    private float getUpdatedCoefficientOfRelationship() {
        return lineageSession.calculateHorsesCoefficientOfRelationship(this.horse);
    }

    private int getUpdatedLineageLines() {
        return lineageSession.calculateHorsesLineageLines(this.horse);
    }

    private int getUpdatedIncestCount() {
        return lineageSession.calculateIncestCount(this.horse);
    }
}

