/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.lineage;

import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.lineage.LineageSession;
import com.equestricraft.core.horse.lineage.TreeNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class LineageSessionImpl
implements LineageSession {
    @Override
    public TreeNode buildHorsesLineageTree(EQHorse horse, int maximumLevels) {
        return this.buildNodes(horse, 0, maximumLevels);
    }

    private TreeNode buildNodes(EQHorse horse, int level, int maximum) {
        if (maximum > 0 && level >= maximum) {
            return null;
        }
        TreeNode motherNode = null;
        TreeNode fatherNode = null;
        if (horse.hasParents()) {
            int nextLevel = level + 1;
            motherNode = this.buildNodes(horse.getMother().getEqHorse(), nextLevel, maximum);
            fatherNode = this.buildNodes(horse.getFather().getEqHorse(), nextLevel, maximum);
        }
        return new TreeNode(level, horse, motherNode, fatherNode);
    }

    private TreeNode buildHorsesLineageTree(EQHorse horse) {
        return this.buildHorsesLineageTree(horse, 0);
    }

    @Override
    public List<EQHorse> getHorsesWithinLineageLevels(EQHorse horse, int maximumLevels) {
        TreeNode treeNode = this.buildHorsesLineageTree(horse, maximumLevels);
        LinkedList<EQHorse> horses = new LinkedList<EQHorse>();
        this.buildLevel(horses, treeNode, 1);
        return horses;
    }

    private void buildLevel(List<EQHorse> horses, TreeNode node, int currentLevel) {
        if (!node.hasNextLevel()) {
            return;
        }
        horses.add(node.mother().horse());
        horses.add(node.father().horse());
        int nextLevel = currentLevel + 1;
        this.buildLevel(horses, node.mother(), nextLevel);
        this.buildLevel(horses, node.father(), nextLevel);
    }

    @Override
    public float calculateHorsesCoefficientOfRelationship(EQHorse horse) {
        if (!horse.hasParents()) {
            return 0.0f;
        }
        return this.calculateHorsesCoefficientOfRelationship(horse.getMother().getEqHorse(), horse.getFather().getEqHorse());
    }

    @Override
    public float calculateHorsesCoefficientOfRelationship(EQHorse horse1, EQHorse horse2) {
        TreeNode node2;
        TreeNode node1 = this.buildHorsesLineageTree(horse1);
        Set<TreeNode> commonAncestors = this.extractCommonAncestors(node1, node2 = this.buildHorsesLineageTree(horse2));
        if (commonAncestors.isEmpty()) {
            return 0.0f;
        }
        double result = commonAncestors.stream().mapToDouble(n -> Math.pow(0.5, this.calculateJumps((TreeNode)n, node1, node2))).sum();
        return (float)result;
    }

    private Set<TreeNode> extractCommonAncestors(TreeNode node1, TreeNode node2) {
        Set<TreeNode> node1UniqueNodes = this.extractUniqueNodes(node1);
        Set<TreeNode> node2UniqueNodes = this.extractUniqueNodes(node2);
        node1UniqueNodes.retainAll(node2UniqueNodes);
        return node1UniqueNodes;
    }

    private int calculateJumps(TreeNode commonAncestor, TreeNode node1, TreeNode node2) {
        int node1ToCommonDistance = this.countJumpsBetweenNodes(node1, commonAncestor);
        int node2ToCommonDistance = this.countJumpsBetweenNodes(node2, commonAncestor);
        return node1ToCommonDistance + node2ToCommonDistance;
    }

    private int countJumpsBetweenNodes(TreeNode node, TreeNode target) {
        AtomicInteger counter = new AtomicInteger();
        boolean found = this.countJumpsBetweenNodes(counter, node, target);
        if (!found) {
            throw new IllegalArgumentException("The target node is not an ancestor of the give node");
        }
        return counter.get();
    }

    private boolean countJumpsBetweenNodes(AtomicInteger counter, TreeNode node, TreeNode target) {
        if (node.equals(target)) {
            return true;
        }
        if (!node.hasNextLevel()) {
            return false;
        }
        counter.incrementAndGet();
        boolean foundOnMotherSide = this.countJumpsBetweenNodes(counter, node.mother(), target);
        if (foundOnMotherSide) {
            return true;
        }
        boolean foundOnFatherSide = this.countJumpsBetweenNodes(counter, node.father(), target);
        if (foundOnFatherSide) {
            return true;
        }
        counter.decrementAndGet();
        return false;
    }

    @Override
    public int calculateHorsesLineageLines(EQHorse horse) {
        TreeNode node = this.buildHorsesLineageTree(horse);
        Set<TreeNode> lineageNodes = this.extractUniqueNodes(node);
        return lineageNodes.size();
    }

    @Override
    public int calculateIncestCount(EQHorse horse) {
        TreeNode node = this.buildHorsesLineageTree(horse);
        int totalNodesCount = this.countAllNodes(node);
        int uniqueNodesCount = this.countUniqueNodes(node);
        return totalNodesCount - uniqueNodesCount;
    }

    private int countAllNodes(TreeNode node) {
        List<TreeNode> allNodes = this.extractAllNodes(node);
        return allNodes.size();
    }

    private List<TreeNode> extractAllNodes(TreeNode node) {
        LinkedList<TreeNode> list = new LinkedList<TreeNode>();
        if (node.hasNextLevel()) {
            this.deepExtractNodes(list, node.mother());
            this.deepExtractNodes(list, node.father());
        }
        return list;
    }

    private int countUniqueNodes(TreeNode node) {
        Set<TreeNode> uniqueNodes = this.extractUniqueNodes(node);
        return uniqueNodes.size();
    }

    private Set<TreeNode> extractUniqueNodes(TreeNode node) {
        HashSet<TreeNode> set2 = new HashSet<TreeNode>();
        if (node.hasNextLevel()) {
            this.deepExtractNodes(set2, node.mother());
            this.deepExtractNodes(set2, node.father());
        }
        return set2;
    }

    private void deepExtractNodes(Collection<TreeNode> nodes, TreeNode node) {
        nodes.add(node);
        if (node.hasNextLevel()) {
            this.deepExtractNodes(nodes, node.mother());
            this.deepExtractNodes(nodes, node.father());
        }
    }
}

