/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.list;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.ObjectUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.list.HorseListItem;
import com.equestricraft.core.horse.list.HorseListPage;
import com.equestricraft.core.horse.list.HorseListSession;
import com.equestricraft.core.horse.list.HorseListSortOrder;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.Comparator;
import java.util.List;

public class HorseListSessionImpl
extends Pagination<HorseListItem, HorseListPage, HorseListSortOrder, String>
implements HorseListSession {
    @Service
    private PlayerTransformer playerTransformer;
    private static final int MAXIMUM_PER_PAGE = 10;

    @Override
    public HorseListPage retrieveHorseListForPlayer(ECPlayer player, HorseListSortOrder horseListSortOrder, SortDirection sortDirection, int pageNumber, String textSearch) {
        List<EQHorse> ownHorses = player.getHorses().getLiving();
        List<EQHorse> trustedHorses = player.getHorses().getWithAccessTo();
        List horses = ListUtils.concat(ownHorses, trustedHorses);
        List<HorseListItem> items = horses.stream().map(h -> this.buildHorseListItem(player, (EQHorse)h)).toList();
        return (HorseListPage)this.paginate(items, pageNumber, sortDirection, horseListSortOrder, textSearch);
    }

    private HorseListItem buildHorseListItem(ECPlayer listOwner, EQHorse horse) {
        ECPlayer owner = listOwner.getId() != horse.getOwnerId() ? horse.getOwner() : null;
        return new HorseListItem(horse.getId(), horse.getName(), horse.getShowName(), ObjectUtils.nullable(owner, o -> this.playerTransformer.toSimple(o.getCorePlayer())), horse.getHorseGender().getTranslatedName(), horse.getAge().getDisplayString(), horse.isImmortal(), horse.getHealth().getStatus());
    }

    @Override
    protected int getMaximumPerPage() {
        return 10;
    }

    @Override
    protected boolean filter(HorseListItem item, String filterObject) {
        String text = filterObject.toLowerCase();
        return item.name().toLowerCase().contains(text) || item.showName() != null && item.showName().toLowerCase().contains(text);
    }

    @Override
    protected Comparator<HorseListItem> compare(HorseListSortOrder sortOrder) {
        return switch (sortOrder) {
            default -> throw new IncompatibleClassChangeError();
            case HorseListSortOrder.NATURAL -> Comparator.comparingInt(HorseListItem::id);
            case HorseListSortOrder.AGE -> Comparator.comparing(HorseListItem::age);
        };
    }

    @Override
    protected HorseListPage buildPage(List<HorseListItem> items, int pageNumber, int totalPages, SortDirection sortDirection, HorseListSortOrder sortOrder, String filter) {
        return new HorseListPage(items, sortOrder, sortDirection, pageNumber, totalPages, filter);
    }
}

