/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.location;

import com.equestricraft.api.common.APIEntityLocationDto;
import com.equestricraft.api.common.APILocationDto;
import com.equestricraft.base.location.LocationTransformer;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.horse.location.HorseLocationAccessor;
import groovy.lang.Closure;
import java.util.Optional;

public class APIHorseLocation
implements APIEntityLocationDto {
    private final HorseLocationAccessor horseLocationAccessor;
    @Service
    private static LocationTransformer locationTransformer;

    public APIHorseLocation(HorseLocationAccessor horseLocationAccessor) {
        this.horseLocationAccessor = horseLocationAccessor;
    }

    @Override
    public APILocationDto getCurrent() {
        Optional<DirectionalCoordinate> location = this.horseLocationAccessor.getLocation();
        return location.map(locationTransformer::toDto).orElse(null);
    }

    @Override
    public void setCurrent(APILocationDto location) {
        DirectionalCoordinate coordinate = locationTransformer.fromDto(location);
        this.horseLocationAccessor.setLocation(coordinate);
    }

    @Override
    public void teleport(Closure<?> config) {
        APILocationDto location = this.buildLocation(config);
        this.setCurrent(location);
    }

    private APILocationDto buildLocation(Closure<?> closure) {
        APILocationDto location = new APILocationDto();
        closure.setDelegate(location);
        closure.call();
        return location;
    }
}

