/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.location;

import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.stress.HorseStressProvider;

public class HorseLocationStressProvider
implements HorseStressProvider {
    @Override
    public float getStressPercentage(EQHorse horse) {
        return horse.getLocation().getLocation().map(DirectionalCoordinate::world).map(ECLevel::getByIdentifier).map(l -> Float.valueOf(this.levelStress((ECLevel)((Object)l), horse))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private float levelStress(ECLevel level, EQHorse horse) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case ECLevel.OVERWORLD, ECLevel.PLOT_GRID, ECLevel.PLOT_NATURAL -> 0.0f;
            case ECLevel.EXPLORE -> this.determineExploreStress(horse);
            case ECLevel.NETHER, ECLevel.END -> 1.0f;
        };
    }

    private float determineExploreStress(EQHorse horse) {
        if (horse.getAge().getYears() < 2.0) {
            return 0.2f;
        }
        return 0.15f;
    }
}

