/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.medicine;

import com.equestricraft.api.common.APIHorseMedicineCategoriesDto;
import com.equestricraft.api.common.APIHorseMedicineCategoryDto;
import com.equestricraft.api.common.APIMedicineCategoryDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.horse.medicine.APIHorseMedicineCategoryDtoImpl;
import com.equestricraft.core.horse.medicine.HorseMedicineAccessor;
import com.equestricraft.core.medicine.category.MedicineCategory;
import com.equestricraft.core.medicine.category.MedicineCategoryRepository;
import com.equestricraft.core.medicine.category.MedicineCategoryTransformer;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class APIHorseMedicineCategoriesDtoImpl
extends MapAdapter<APIMedicineCategoryDto, APIHorseMedicineCategoryDto>
implements APIHorseMedicineCategoriesDto {
    private final HorseMedicineAccessor horseMedicineAccessor;
    @Service
    private static MedicineCategoryRepository medicineCategoryRepository;
    @Service
    private static MedicineCategoryTransformer medicineCategoryTransformer;

    public APIHorseMedicineCategoriesDtoImpl(HorseMedicineAccessor horseMedicineAccessor) {
        this.horseMedicineAccessor = horseMedicineAccessor;
    }

    @Override
    public int size() {
        return medicineCategoryRepository.getTotalSize();
    }

    @Override
    public APIHorseMedicineCategoryDto get(Object key) {
        MedicineCategory category = this.getFromKey(key);
        return new APIHorseMedicineCategoryDtoImpl(this.horseMedicineAccessor, category);
    }

    private MedicineCategory getFromKey(Object key) {
        if (key instanceof APIMedicineCategoryDto) {
            APIMedicineCategoryDto dto = (APIMedicineCategoryDto)key;
            return medicineCategoryTransformer.fromApiDto(dto);
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return (MedicineCategory)medicineCategoryRepository.findByKey(id);
        }
        if (key instanceof String) {
            String identifier = (String)key;
            return medicineCategoryRepository.findByIdentifier(identifier).orElseThrow();
        }
        throw new IllegalArgumentException("Invalid key provided");
    }

    @Override
    public Set<Map.Entry<APIMedicineCategoryDto, APIHorseMedicineCategoryDto>> entrySet() {
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<APIMedicineCategoryDto, APIHorseMedicineCategoryDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<APIMedicineCategoryDto, APIHorseMedicineCategoryDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return medicineCategoryRepository.getTotalSize();
        }

        final class EntrySetIterator
        implements Iterator<Map.Entry<APIMedicineCategoryDto, APIHorseMedicineCategoryDto>> {
            private final Iterator<MedicineCategory> iterator = medicineCategoryRepository.iterator();

            EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<APIMedicineCategoryDto, APIHorseMedicineCategoryDto> next() {
                MedicineCategory next = this.iterator.next();
                APIMedicineCategoryDto dto = medicineCategoryTransformer.toApiDto(next);
                return Map.entry(dto, new APIHorseMedicineCategoryDtoImpl(APIHorseMedicineCategoriesDtoImpl.this.horseMedicineAccessor, next));
            }
        }
    }
}

