/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.medicine;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseMedicineCategoryDto;
import com.equestricraft.api.common.APIMedicineCategoryDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.medicine.HorseMedicineAccessor;
import com.equestricraft.core.medicine.category.MedicineCategory;
import com.equestricraft.core.medicine.category.MedicineCategoryTransformer;
import groovy.lang.Closure;

public class APIHorseMedicineCategoryDtoImpl
implements APIHorseMedicineCategoryDto {
    private final HorseMedicineAccessor horseMedicineAccessor;
    private final MedicineCategory medicineCategory;
    @Service
    private static MedicineCategoryTransformer medicineCategoryTransformer;

    public APIHorseMedicineCategoryDtoImpl(HorseMedicineAccessor horseMedicineAccessor, MedicineCategory medicineCategory) {
        this.horseMedicineAccessor = horseMedicineAccessor;
        this.medicineCategory = medicineCategory;
    }

    @Override
    public APIMedicineCategoryDto getCategory() {
        return medicineCategoryTransformer.toApiDto(this.medicineCategory);
    }

    @Override
    public int getDosage() {
        return this.horseMedicineAccessor.getAmountOfMedicineCategoryInHorse(this.medicineCategory);
    }

    @Override
    public int dosage(Closure<?> closure) {
        APIDurationDto duration = new APIDurationDto();
        closure.setDelegate(duration);
        closure.call();
        return this.horseMedicineAccessor.getAmountOfMedicineCategoryInHorse(this.medicineCategory, duration.getDuration());
    }
}

